package com.alibaba.schedulerx.worker.master;

import java.lang.reflect.Constructor;

import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import akka.actor.ActorContext;

/**
 *
 * @author xiaomeng.hxm
 */
public class TaskMasterFactory {
    private static final Logger LOGGER = LogFactory.getLogger(TaskMasterFactory.class);

    public static TaskMaster create(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        TaskMaster taskMaster = null;
        String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_MASTER_PREFIX + jobInstanceInfo.getExecuteMode());
        LOGGER.info("create TaskMaster, className=" + className);
        if (className != null) {
            @SuppressWarnings("unchecked")
            Constructor<? extends TaskMaster> constructor = ((Class<? extends TaskMaster>) Class.forName(className))
                .getConstructor(JobInstanceInfo.class, ActorContext.class);
            taskMaster = constructor.newInstance(jobInstanceInfo, actorContext);
        } else {
            String errMsg = "class not found of " + WorkerConstants.WORKER_MASTER_PREFIX + jobInstanceInfo.getExecuteMode();
            LOGGER.error(errMsg);
            throw new ClassNotFoundException(errMsg);
        }
        return taskMaster;
    }
}
