package com.alibaba.schedulerx.worker.master.persistence;

import java.sql.Connection;
import java.sql.SQLException;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.zaxxer.hikari.HikariDataSource;

/**
 *
 * @author xiaomeng.hxm
 */
public class H2ConnectionPool {
    private HikariDataSource jdbcCP = new HikariDataSource();

    public H2ConnectionPool(String jdbcUrl) {
        String user = ConfigUtil.getWorkerConfig().getString(WorkerConstants.H2_DATABASE_USER_KEY, "sa");
        String password = ConfigUtil.getWorkerConfig().getString(WorkerConstants.H2_DATABASE_PASSWORD_KEY, "");
        jdbcCP.setJdbcUrl(jdbcUrl);
        jdbcCP.setUsername(user);
        jdbcCP.setPassword(password);
        jdbcCP.setMinimumIdle(4);
        jdbcCP.setMaximumPoolSize(32);
        jdbcCP.setDriverClassName("org.h2.Driver");
    }

    public H2ConnectionPool() {
        this("jdbc:h2:mem:schedulerx2;AUTO_RECONNECT=TRUE;MODE=MySQL;DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false");
    }

    public Connection getConnection() throws SQLException {
        return jdbcCP.getConnection();
    }
}
