package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.worker.util.WorkerIdGenerator;

/**
 *
 * @author xiaomeng.hxm
 */
public class H2FilePersistence extends H2Persistence {

    private static H2FilePersistence instance = new H2FilePersistence();
    private H2FilePersistence() {
        this.h2CP = new H2ConnectionPool("jdbc:h2:file:retry:~/.h2/schedulerx2/" + WorkerIdGenerator.get() + ";"
            + "LOG=1;CACHE_SIZE=10240;"
            + "AUTO_SERVER=TRUE;AUTO_RECONNECT=TRUE;"
            + "MODE=MySQL;DB_CLOSE_ON_EXIT=FALSE;"
            + "DB_CLOSE_DELAY=-1;DATABASE_TO_UPPER=false");
        this.taskDao = new TaskDao(h2CP);
    }
    public static H2FilePersistence getInstance() {
        return instance;
    }
}
