package com.alibaba.schedulerx.worker.master.persistence;

import java.util.List;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.protocol.Worker.ContainerReportTaskStatusRequest;
import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;
import com.alibaba.schedulerx.worker.domain.TaskInfo;

import com.google.protobuf.ByteString;

/**
 *
 * @author xiaomeng.hxm
 */
public interface TaskPersistence {
    
    /**
     * init task table;
     * @throws Exception
     */
    void initTable() throws Exception;
    
    ///**
    // * update single task status
    // * @param jobId
    // * @param jobInstanceId
    // * @param taskId
    // * @param status
    // * @param workerAddr
    // * @param workerId
    // * @throws Exception
    // */
    //void updateTaskStatus(long jobId, long jobInstanceId, long taskId, TaskStatus status, String workerAddr,
    //        String workerId) throws Exception;
    
    /**
     * update tasksk status and worker info
     * @param jobInstanceId
     * @param taskIds
     * @param status
     * @param workerId
     * @param workerAddr
     * @throws Exception
     */
    int updateTaskStatus(long jobInstanceId, List<Long> taskIds, TaskStatus status, String workerId,
                          String workerAddr) throws Exception;
    
    /**
     * update task statues accord to list of TaskStatusInfo
     * @param taskStatusInfos list of task status
     * @throws Exception
     */
    void updateTaskStatues(List<ContainerReportTaskStatusRequest> taskStatusInfos) throws Exception;
    
    /**
     * clear all tasks belong to specific job instance
     * @param jobInstanceId
     * @throws Exception
     */
    void clearTasks(long jobInstanceId) throws Exception;
    
    /**
     * create task
     * @param jobId
     * @param jobInstanceId
     * @param taskId
     * @param taskName
     * @param taskBody
     * @throws Exception
     */
    void createTask(long jobId, long jobInstanceId, long taskId, String taskName, ByteString taskBody) throws Exception;
    
    /**
     * batch create container infos
     * @param containers infos of container
     * @throws Exception
     */
    void createTasks(List<MasterStartContainerRequest> containers, String workerId, String workerAddr) throws Exception;
    
    /**
     * pull init tasks for failover retry
     * @param jobInstanceId
     * @param pageSize
     * @return
     * @throws Exception
     */
    List<TaskInfo> pull(long jobInstanceId, int pageSize) throws Exception;
    
    /**
     * check job instance current status
     * @param jobInstanceId
     * @return
     * @throws Exception
     */
    InstanceStatus checkInstanceStatus(Long jobInstanceId) throws Exception;

    /**
     * check job instance current status
     * @param jobInstanceId
     * @return
     * @throws Exception
     */
    InstanceStatus checkInstanceStatus(Long jobInstanceId, Long batchNo) throws Exception;
    
    /**
     * update tasks status using condition {jobInstanceId, workerId, workerAddr}
     * @param jobInstanceId tasks jobInstanceId
     * @param status status to be update
     * @param workerId tasks workerId
     * @param workerAddr tasks workerAddr
     */
    int batchUpdateTaskStatus(long jobInstanceId, TaskStatus status, String workerId, String workerAddr);
}
