package com.alibaba.schedulerx.worker.master.scheduler;

import com.alibaba.schedulerx.worker.master.handler.SecondJobUpdateInstanceStatusHandler;
import java.util.Objects;

/**
 *
 * @author xiaomeng.hxm
 */
public class TimePlanEntry {
    private long jobInstanceId;
    private long scheduleTimeStamp;
    private SecondJobUpdateInstanceStatusHandler handler;

    public TimePlanEntry(long jobInstanceId, long scheduleTimeStamp, SecondJobUpdateInstanceStatusHandler handler) {
        this.jobInstanceId = jobInstanceId;
        this.scheduleTimeStamp = scheduleTimeStamp;
        this.handler = handler;
    }

	public long getJobInstanceId() {
		return jobInstanceId;
	}

	public void setJobInstanceId(long jobInstanceId) {
		this.jobInstanceId = jobInstanceId;
	}

	public long getScheduleTimeStamp() {
		return scheduleTimeStamp;
	}

	public void setScheduleTimeStamp(long scheduleTimeStamp) {
		this.scheduleTimeStamp = scheduleTimeStamp;
	}

	public SecondJobUpdateInstanceStatusHandler getHandler() {
		return handler;
	}

	public void setHandler(SecondJobUpdateInstanceStatusHandler handler) {
		this.handler = handler;
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(jobInstanceId, scheduleTimeStamp);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TimePlanEntry other = (TimePlanEntry) obj;
		return jobInstanceId == other.jobInstanceId && scheduleTimeStamp == other.scheduleTimeStamp;
	}

	@Override
	public String toString() {
		return "TimePlanEntry [jobInstanceId=" + jobInstanceId + ", scheduleTimeStamp=" + scheduleTimeStamp + "]";
	}
	
}
