package com.alibaba.schedulerx.worker.metrics;

/**
 * WorkerLoad
 * @author yaohui
 * @create 2023/5/8 4:38 PM
 **/
public class WorkerLoad {

    private String workerAddr;

    private Integer availableSize;

    private Integer remainCpu;

    private Long remainMemory;

    private Long cost;

    public WorkerLoad(String workerAddr) {
        this.workerAddr = workerAddr;
        // 初始可用大小设置为1，等待初次分发后更新实际可用值
        this.availableSize = 1;
    }

    public String getWorkerAddr() {
        return workerAddr;
    }

    public void setWorkerAddr(String workerAddr) {
        this.workerAddr = workerAddr;
    }

    public Integer getAvailableSize() {
        return availableSize;
    }

    public void setAvailableSize(Integer availableSize) {
        this.availableSize = availableSize;
    }

    public Integer getRemainCpu() {
        return remainCpu;
    }

    public void setRemainCpu(Integer remainCpu) {
        this.remainCpu = remainCpu;
    }

    public Long getRemainMemory() {
        return remainMemory;
    }

    public void setRemainMemory(Long remainMemory) {
        this.remainMemory = remainMemory;
    }

    public Long getCost() {
        return cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public boolean isAvailable(){
        return availableSize != null && availableSize > 0;
    }

//    public void descAvailable(){
//        availableSize--;
//    }

    public double getWeight(){
        long availableSize = this.availableSize==null?0:this.availableSize;
        long remainCpu = this.remainCpu==null?0:this.remainCpu;
        long remainMemory = this.remainMemory==null?0:this.remainMemory;
        long cost = this.cost!=null&&this.cost>0?this.cost+10:10;
        return (availableSize*1000)+(remainCpu*100)+(remainMemory/10)/(Math.sqrt(cost));
    }
}
