package com.alibaba.schedulerx.worker.processor;

import org.apache.commons.lang.StringUtils;

import com.alibaba.schedulerx.common.domain.InstanceStatus;

/**
 *
 * @author xiaomeng.hxm
 */
public class HttpProcessResult extends ProcessResult {

    public HttpProcessResult(InstanceStatus status) {
        super(status);
    }

    public HttpProcessResult(boolean status) {
        super(status);
    }

    public HttpProcessResult(InstanceStatus status, String result) {
        this.result = result;
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = stackInfo();
        }
    }

    private String stackInfo(){
        return "";
    }

    /**
     *
     * @param status
     * @param result, the size should less than 1000 bytes
     * @throws Exception
     */
    public HttpProcessResult(boolean status, String result) {
        this.result = result;
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
        if (InstanceStatus.FAILED.equals(this.status)) {
            this.stackInfo = stackInfo();
        }
    }

    public InstanceStatus getStatus() {
        return status;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = stackInfo();
        } else {
            this.stackInfo = null;
        }
    }

    public void setStatus(boolean status) {
        setStatus(status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
    }

    public String getResult() {
        if (StringUtils.isEmpty(result) && StringUtils.isNotEmpty(stackInfo)) {
            return stackInfo;
        }
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "ProcessResult [status=" + status + ", result=" + result + "]";
    }
    
}
