package com.alibaba.schedulerx.worker.processor;

import org.apache.commons.lang.StringUtils;

import com.alibaba.schedulerx.common.constants.CommonConstants;
import com.alibaba.schedulerx.common.domain.InstanceStatus;

/**
 *
 * @author xiaomeng.hxm
 */
public class ProcessResult {

    protected InstanceStatus status;

    protected String result;

    protected String stackInfo;
    
    public ProcessResult() {}

    public ProcessResult(InstanceStatus status) {
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = stackInfo();
        }
    }

    public ProcessResult(boolean status) {
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
        if (!status){
            this.stackInfo = stackInfo();
        }
    }

    public ProcessResult(InstanceStatus status, String result) {
        if (result != null && result.getBytes().length > CommonConstants.INSTANCE_RESULT_SIZE_MAX) {
            this.result = StringUtils.substring(result, 0, CommonConstants.INSTANCE_RESULT_SIZE_MAX-10)+"...";
        } else {
            this.result = result;
        }
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = stackInfo();
        }
    }

    private String stackInfo(){
        //TODO only for advance version
//        ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
//        ThreadInfo threadInfo = threadMBean.getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
//        return ManagementUtil.formatThreadInfo(threadInfo, 25, 4);
        return "";
    }

    /**
     *
     * @param status
     * @param result, the size should less than 1000 bytes
     * @throws Exception
     */
    public ProcessResult(boolean status, String result) {
        if (result != null && result.getBytes().length > CommonConstants.INSTANCE_RESULT_SIZE_MAX) {
            this.result = StringUtils.substring(result, 0, CommonConstants.INSTANCE_RESULT_SIZE_MAX-10)+"...";
        } else {
            this.result = result;
        }
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
        if (InstanceStatus.FAILED.equals(this.status)) {
            this.stackInfo = stackInfo();
        }
    }

    public InstanceStatus getStatus() {
        return status;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status;
        if (InstanceStatus.FAILED.equals(status)) {
            this.stackInfo = stackInfo();
        } else {
            this.stackInfo = null;
        }
    }

    public void setStatus(boolean status) {
        setStatus(status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
    }

    public String getResult() {
        if (StringUtils.isEmpty(result) && StringUtils.isNotEmpty(stackInfo)) {
            return StringUtils.substring(stackInfo, 0, CommonConstants.INSTANCE_RESULT_SIZE_MAX);
        }
        return result;
    }

    public void setResult(String result) {
        if (result != null && result.getBytes().length > CommonConstants.INSTANCE_RESULT_SIZE_MAX) {
            this.result = StringUtils.substring(result, 0, CommonConstants.INSTANCE_RESULT_SIZE_MAX-10)+"...";
        } else {
            this.result = result;
        }
    }

    @Override
    public String toString() {
        return "ProcessResult [status=" + status + ", result=" + result + "]";
    }
    
}
