package com.alibaba.schedulerx.worker.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.alibaba.schedulerx.common.domain.ScriptJobXAttrs;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.google.common.collect.Lists;
import com.google.common.io.Files;

/**
 *
 * @author xiaomeng.hxm
 */
public class PythonProcessor extends ShellProcessor {

    public static final String PYTHON_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/python/";
    protected String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(PYTHON_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        fileName = writePythonScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters;
        if (StringUtils.isNotEmpty(context.getShardingParameter())) {
            parameters = new String[2];
            parameters[0] = String.valueOf(context.getShardingId());
            parameters[1] = context.getShardingParameter();
        } else if (StringUtils.isNotEmpty(context.getInstanceParameters())) {
            parameters = context.getInstanceParameters().trim().split(" ");
        } else {
            parameters = context.getJobParameters().trim().split(" ");
        }
        List<String> contentList = Lists.newArrayList();
        ScriptJobXAttrs xAttrs = null;
        if (StringUtils.isNotEmpty(context.getXAttrs())) {
            xAttrs = JsonUtil.fromJson(context.getXAttrs(), ScriptJobXAttrs.class);
        }
        // 芯片架构，比如arch -arm64
        if (xAttrs != null && StringUtils.isNotEmpty(xAttrs.getArch())) {
            contentList.add("arch");
            contentList.add("-" + xAttrs.getArch());
        }
        // python执行命令，比如python2或者python3
        if (xAttrs != null && StringUtils.isNotEmpty(xAttrs.getCommand())) {
            contentList.add(xAttrs.getCommand());
        } else {
            contentList.add("python");
        }
        
        contentList.add(fileName);
        for (int i = 0; i < parameters.length; i++) {
            contentList.add(parameters[i]);
        }
        return contentList.toArray(new String[contentList.size()]);
    }

    private String writePythonScript(JobContext context) throws IOException {
        //TODO 加入version
        long jobId = context.getJobId();
        String fileName = PYTHON_SCRIPT_PREFIX + "python_" + jobId + ".py";
        // add # -*- coding: utf-8 -*- to first line of python script file to make this file utf-8 encode.
        String content = parseContent(context);
        content = "# -*- coding: utf-8 -*-" + System.lineSeparator() + content;
        Files.write(content.getBytes(), new File(fileName));
        return fileName;
    }

}
