package com.alibaba.schedulerx.worker.pull;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;

/**
 *
 * @author xiaomeng.hxm
 */
public class BlockingContainerQueue {

    private final BlockingQueue<MasterStartContainerRequest> queue;

    public BlockingContainerQueue(int capacity) {
        this.queue = new LinkedBlockingQueue<>(capacity);
    }

    public MasterStartContainerRequest get() throws InterruptedException {
        return queue.poll(5, TimeUnit.SECONDS);
    }

    public boolean put(MasterStartContainerRequest request) throws InterruptedException {
        return queue.offer(request, 5, TimeUnit.SECONDS);
    }

    public void clear() {
        queue.clear();
    }

    public int size() {
        return queue.size();
    }

}
