package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.util.IdUtil;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author dingxuan
 */
public enum RouterManager {
    INSTANCE;

    public Map<String, Router> groupRouterMap = Maps.newConcurrentMap();

    public Router getRouter(long appGroupId, long jobId) {
        String key = IdUtil.getRouteStrategyUniqueId(appGroupId, jobId);
        if (groupRouterMap.containsKey(key)) {
            return groupRouterMap.get(key);
        } else {
            return null;
        }
    }

    public void updateRouter(long appGroupId, long jobId, Router router) {
        String key = IdUtil.getRouteStrategyUniqueId(appGroupId, jobId);
        groupRouterMap.put(key, router);
    }


}
