package com.alibaba.schedulerx.worker.util;

import java.util.Random;

import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import org.apache.commons.lang.StringUtils;

/**
 * diamond配置获取
 *
 * @author 陆昆
 * @create 2019-03-13 下午3:22
 **/
public class DiamondUtil {
    private static final Logger LOGGER = LogFactory.getLogger(DiamondUtil.class);

    public static String getData(String dataId) {
        return getData(dataId, "DEFAULT_GROUP");
    }

    public static String getData(String dataId, String group) {
        String result = StringUtils.EMPTY;
        try {
            String url1 = "http://jmenv.tbsite.net:8080/diamond-server/diamond";
            HttpResponse<String> response = Unirest.get(url1).asString();
            String[] ipList = response.getBody().split("\n");
            int size = ipList.length;
            int index = new Random().nextInt(size);
            String url2 = "http://" + ipList[index] + ":8080/diamond-server/config.co?dataId=" + dataId + "&group=" + group;
            HttpResponse<String> response2 = Unirest.get(url2).asString();
            LOGGER.info("url=" + url2);
            result = response2.getBody();
        } catch (Throwable e) {
            LOGGER.warn("[DiamondUtil]getData error dataId={}", dataId, e);
        }
        return result;
    }
}
