package com.alibaba.schedulerx.worker.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;

import com.google.common.collect.Lists;

/**
 *
 * @author xiaomeng.hxm
 */
public class ShellUtil {

    public static ProcessBuilder createShellProcessBuilder(String cmd) {
        return new ProcessBuilder("/bin/sh", "-c", cmd);
    }

    public static ProcessBuilder createProcessBuilder(String[] cmds) {
        return new ProcessBuilder(cmds);
    }

    public static List<String> executeShell(String cmd) throws IOException {
        return executeShell(cmd, -1);
    }

    public static List<String> executeShell(String[] cmds, long timeout) throws IOException {
        try {
            ProcessBuilder pb = ShellUtil.createProcessBuilder(cmds);
            Process p = pb.start();
            int exitCode = 0;
            exitCode = p.waitFor();
            
            InputStream stdOutStream = p.getInputStream();
            InputStream errStream = p.getErrorStream();
            BufferedReader br = null;
            if (exitCode == 0) {
                br = new BufferedReader(new InputStreamReader(stdOutStream, StandardCharsets.UTF_8));
            } else {
                br = new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8));
            }
            List<String> result = Lists.newArrayList();
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            return result;
        } catch (Throwable e) {
            throw new IOException(e);
        }
    }
    
    public static List<String> executeShell(String cmd, long timeout) throws IOException {
        try {
            ProcessBuilder pb = ShellUtil.createShellProcessBuilder(cmd);
            Process p = pb.start();
            int exitCode = 0;
            exitCode = p.waitFor();
            
            InputStream stdOutStream = p.getInputStream();
            InputStream errStream = p.getErrorStream();
            BufferedReader br = null;
            if (exitCode == 0) {
                br = new BufferedReader(new InputStreamReader(stdOutStream, StandardCharsets.UTF_8));
            } else {
                br = new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8));
            }
            List<String> result = Lists.newArrayList();
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            return result;
        } catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static long getPidOfProcess(Process p) {
        long pid = -1;

        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        } catch (Throwable e) {
            pid = -1;
        }
        return pid;
    }

    public static void killProcess(long pid) throws IOException {
    }


    /**
     * stringList convert to String
     * @param stringList
     * @return
     */
    public static String stringListToString(List<String> stringList){
        StringBuilder builder=new StringBuilder();
        for (int i = 0; i < stringList.size(); i++) {
            builder.append(stringList.get(i)).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static void main(String[] args) throws IOException {
        String[] cmds = new String[] {"python","/Users/armon/script/python/python_6230549.py"};
        List<String> lines = ShellUtil.executeShell(cmds, -1);
        for (String line : lines) {
            System.out.println(line);
        }
    }


}
