package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;

/**
 * Worker config util
 * @author yaohui
 * @create 2022/11/1 下午3:57
 **/
public class WorkerConfigUtil {

    /**
     * 是否开启全局共享线程池
     * @return
     */
    public static boolean isEnableShareContainerPool() {
        String mode = ConfigUtil.getWorkerConfig().getString(WorkerConstants.THREAD_POOL_MODE);
        if (StringUtils.isNotEmpty(mode)) {
            return WorkerConstants.THREAD_POOL_MODE_ALL.equals(mode);
        } else {
            boolean isEnableShareContainerPool = ConfigUtil.getWorkerConfig().getBoolean(WorkerConstants.SHARE_CONTAINER_POOL, false);
            return isEnableShareContainerPool;
        }
    }

    /**
     * 获取线程池模型
     * @return
     */
    public static String getThreadPoolMode() {
        String mode = ConfigUtil.getWorkerConfig().getString(WorkerConstants.THREAD_POOL_MODE, WorkerConstants.THREAD_POOL_MODE_DEFAULT);
        return mode;
    }

}
