/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import java.util.Map;

public enum ExecuteMode {
    STANDALONE("standalone", "\u5355\u673a\u8fd0\u884c"),
    BROADCAST("broadcast", "\u5e7f\u64ad\u8fd0\u884c"),
    PARALLEL("parallel", "\u53ef\u89c6\u5316MapReduce"),
    GRID("grid", "MapReduce"),
    BATCH("batch", "MapReduce"),
    STREAM("stream", "Stream"),
    SHARDING("sharding", "\u5206\u7247\u8fd0\u884c");

    private String key;
    private String desc;
    static Map<String, ExecuteMode> CACHE;

    private ExecuteMode(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static ExecuteMode getByKey(String key) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        ExecuteMode mode = CACHE.get(key);
        if (mode == null) {
            for (ExecuteMode value : ExecuteMode.values()) {
                if (!StringUtils.equalsIgnoreCase(key, value.getKey())) continue;
                mode = value;
                CACHE.put(key, mode);
                break;
            }
        }
        return mode;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    static {
        CACHE = Maps.newHashMap();
    }
}

