/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.domain.enums.MessageCode;

public enum InstanceStatus implements MessageCode
{
    UNKNOWN(0, false, "unknown"),
    WAITING(1, false, "waiting"),
    READY(2, false, "ready"),
    RUNNING(3, false, "running"),
    SUCCESS(4, true, "success"),
    FAILED(5, true, "failed"),
    PAUSED(7, false, "paused"),
    SUBMITTED(8, false, "submitted"),
    REJECTED(9, false, "rejected"),
    ACCEPTED(10, false, "accepted"),
    PARTIAL_FAILED(11, false, "partial_failed"),
    SKIPPED(12, true, "skipped"),
    REMOVED(99, true, "removed");

    private int value;
    private String description;
    private boolean isFinish;

    private InstanceStatus(int value, boolean isFinish, String description) {
        this.value = value;
        this.description = description;
        this.isFinish = isFinish;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public static InstanceStatus parseValue(int value) {
        InstanceStatus[] statusList;
        for (InstanceStatus s2 : statusList = InstanceStatus.values()) {
            if (s2.getValue() != value) continue;
            return s2;
        }
        throw new IllegalArgumentException("InstanceStatus value is invalid. value:" + value);
    }

    @Override
    public String getMessageCode() {
        return InstanceStatus.class.getSimpleName() + "." + this.name();
    }
}

