/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.domain.ContentType;

public enum JobType {
    JAVA("java", ContentType.TEXT),
    PYTHON("python", ContentType.SCRIPT),
    SHELL("shell", ContentType.SCRIPT),
    GO("go", ContentType.SCRIPT),
    HTTP("http", ContentType.TEXT),
    XXLJOB("xxljob", ContentType.TEXT),
    DATAWORKS("dataworks", ContentType.TEXT),
    K8S("k8s", ContentType.SCRIPT),
    SPRINGSCHEDULE("springschedule", ContentType.TEXT),
    GOLANG("golang", ContentType.TEXT),
    AIGC("aigc", ContentType.TEXT);

    private String key;
    private ContentType contentType;

    private JobType(String key, ContentType type) {
        this.key = key;
        this.contentType = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType type) {
        this.contentType = type;
    }

    public static JobType parseValue(String value) {
        JobType[] list;
        for (JobType type : list = JobType.values()) {
            if (!type.getKey().equals(value)) continue;
            return type;
        }
        return null;
    }
}

