/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import java.util.concurrent.atomic.AtomicInteger;

public class TaskProgressCounter {
    private final String name;
    private AtomicInteger total = new AtomicInteger(0);
    private AtomicInteger pulled = new AtomicInteger(0);
    private AtomicInteger running = new AtomicInteger(0);
    private AtomicInteger success = new AtomicInteger(0);
    private AtomicInteger failed = new AtomicInteger(0);

    public TaskProgressCounter(String name) {
        this.name = name;
    }

    public void incrementTotal() {
        this.total.incrementAndGet();
    }

    public void incrementTotal(int delta) {
        this.total.addAndGet(delta);
    }

    public void incrementPulled() {
        this.pulled.incrementAndGet();
    }

    public void incrementPulled(int delta) {
        this.pulled.addAndGet(delta);
    }

    public void incrementRunning() {
        if (this.pulled.get() > 0) {
            this.pulled.decrementAndGet();
        }
        this.running.incrementAndGet();
    }

    public void incrementRunning(int delta) {
        if (this.pulled.get() >= delta) {
            this.pulled.addAndGet(-delta);
        }
        this.running.addAndGet(delta);
    }

    public void decrementRunning() {
        if (this.running.get() > 0) {
            this.running.decrementAndGet();
        }
        this.pulled.incrementAndGet();
    }

    public void incrementSuccess() {
        if (this.running.get() > 0) {
            this.running.decrementAndGet();
        }
        this.success.incrementAndGet();
    }

    public void incrementSuccess(int delta) {
        if (this.running.get() >= delta) {
            this.running.addAndGet(-delta);
        }
        this.success.addAndGet(delta);
    }

    public void decrementSuccess() {
        if (this.success.get() > 0) {
            this.success.decrementAndGet();
        }
    }

    public void incrementFailed() {
        if (this.running.get() > 0) {
            this.running.decrementAndGet();
        } else if (this.pulled.get() > 0) {
            this.pulled.decrementAndGet();
        }
        this.failed.incrementAndGet();
    }

    public void incrementFailed(int delta) {
        int temp = this.running.addAndGet(-delta);
        if (temp < 0) {
            this.pulled.addAndGet(temp);
            this.running.addAndGet(-temp);
        }
        this.failed.addAndGet(delta);
    }

    public void decrementFailed() {
        if (this.failed.get() > 0) {
            this.failed.decrementAndGet();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getTotal() {
        return this.total.get();
    }

    public int getSuccess() {
        return this.success.get();
    }

    public int getFailed() {
        return this.failed.get();
    }

    public int getPulled() {
        return this.pulled.get();
    }

    public int getRunning() {
        return this.running.get();
    }

    public void merge(TaskProgressCounter taskProgressCounter) {
        this.total.addAndGet(taskProgressCounter.getTotal());
        this.pulled.addAndGet(taskProgressCounter.getPulled());
        this.running.addAndGet(taskProgressCounter.getRunning());
        this.success.addAndGet(taskProgressCounter.getSuccess());
        this.failed.addAndGet(taskProgressCounter.getFailed());
    }
}

