/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.domain.enums.MessageCode;

public enum TaskStatus implements MessageCode
{
    UNKNOWN(0, "unknown", false),
    INIT(1, "init", false),
    PULLED(2, "pulled", false),
    RUNNING(3, "running", false),
    SUCCESS(4, "success", true),
    FAILED(5, "failed", true);

    private int value;
    private String description;
    private boolean isFinish;

    private TaskStatus(int value, String description, boolean isFinish) {
        this.value = value;
        this.description = description;
        this.isFinish = isFinish;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public static TaskStatus parseValue(int value) {
        TaskStatus[] statusList;
        for (TaskStatus s2 : statusList = TaskStatus.values()) {
            if (s2.getValue() != value) continue;
            return s2;
        }
        throw new IllegalArgumentException("InstanceStatus value is invalid. value:" + value);
    }

    @Override
    public String getMessageCode() {
        return TaskStatus.class.getSimpleName() + "." + this.name();
    }
}

