/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.domain.Metrics;
import com.alibaba.schedulerx.common.domain.enums.WorkerBusyStatusEnum;
import java.util.Objects;

public class WorkerInfo {
    private final String ip;
    private final int port;
    private final String workerId;
    private final String workerAddr;
    private final String akkaPath;
    private Metrics metrics;
    private final String version;
    private String starter;
    private final String label;
    private int rpcPort;
    private WorkerBusyStatusEnum busyStatus = WorkerBusyStatusEnum.FREE;
    private final String userCategory;

    public WorkerInfo(String ip, int port, String workerId, String version) {
        this(ip, port, workerId, version, null, null);
    }

    public WorkerInfo(String ip, int port, String workerId, String version, String userCategory, String label) {
        this.ip = ip;
        this.port = port;
        this.workerId = workerId;
        this.workerAddr = workerId + "@" + ip + ":" + port;
        this.akkaPath = "akka.tcp://" + workerId + "@" + ip + ":" + port + "/user/job_instance_routing";
        this.version = version;
        this.userCategory = userCategory;
        this.label = label;
    }

    public WorkerInfo(String ip, int port, String workerId, String version, String userCategory, String label, int rpcPort) {
        this.ip = ip;
        this.port = port;
        this.rpcPort = rpcPort;
        this.workerId = workerId;
        this.workerAddr = rpcPort != port ? workerId + "@" + ip + ":" + port + ":" + rpcPort : workerId + "@" + ip + ":" + port;
        this.akkaPath = "akka.tcp://" + workerId + "@" + ip + ":" + port + "/user/job_instance_routing";
        this.version = version;
        this.userCategory = userCategory;
        this.label = label;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getWorkerAddr() {
        return this.workerAddr;
    }

    public String getAddr() {
        return this.ip + ":" + this.port;
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkerInfo other = (WorkerInfo)obj;
        return Objects.equals(this.ip, other.ip) && Objects.equals(this.port, other.port);
    }

    public String getAkkaPath() {
        return this.akkaPath;
    }

    public String getLogAkkaPath() {
        return "akka.tcp://" + this.workerId + "@" + this.ip + ":" + this.port + "/user/log_routing";
    }

    public String toString() {
        return "WorkerInfo [ip=" + this.ip + ", port=" + this.port + ", workerId=" + this.workerId + ", metrics=" + this.metrics + "]";
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public WorkerBusyStatusEnum getBusyStatus() {
        return this.busyStatus;
    }

    public void setBusyStatus(WorkerBusyStatusEnum busyStatus) {
        this.busyStatus = busyStatus;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStarter() {
        return this.starter;
    }

    public void setStarter(String starter) {
        this.starter = starter;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUserCategory() {
        return this.userCategory;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }
}

