/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import java.util.concurrent.atomic.AtomicInteger;

public class WorkerProgressCounter {
    private final String workerAddr;
    private AtomicInteger total = new AtomicInteger(0);
    private AtomicInteger pulled = new AtomicInteger(0);
    private AtomicInteger running = new AtomicInteger(0);
    private AtomicInteger success = new AtomicInteger(0);
    private AtomicInteger failed = new AtomicInteger(0);
    private String traceId;

    public WorkerProgressCounter(String workerAddr) {
        this.workerAddr = workerAddr;
    }

    public void incrementTotal() {
        this.total.incrementAndGet();
    }

    public void incrementPulled() {
        this.pulled.incrementAndGet();
    }

    public void incrementRunning() {
        if (this.pulled.get() > 0) {
            this.pulled.decrementAndGet();
        }
        this.running.incrementAndGet();
    }

    public void decRunningAndTotal(int delta) {
        int temp = this.running.addAndGet(-delta);
        if (temp < 0) {
            this.pulled.addAndGet(temp);
            this.running.addAndGet(-temp);
        }
        this.total.addAndGet(-delta);
    }

    public void decPulledAndTotal(int delta) {
        this.total.addAndGet(-delta);
        if (this.pulled.get() > 0) {
            this.pulled.addAndGet(-delta);
        }
    }

    public void incrementSuccess() {
        if (this.running.get() > 0) {
            this.running.decrementAndGet();
        }
        this.success.incrementAndGet();
    }

    public void decrementSuccess() {
        if (this.success.get() > 0) {
            this.success.decrementAndGet();
        }
    }

    public void incrementFailed(int delta) {
        int diff2 = this.total.get() - (this.failed.get() + this.success.get());
        int temp = this.running.addAndGet(-(delta = Math.min(delta, diff2)));
        if (temp < 0) {
            this.pulled.addAndGet(temp);
            this.running.addAndGet(-temp);
        }
        this.failed.addAndGet(delta);
    }

    public void incrementFailed() {
        if (this.running.get() > 0) {
            this.running.decrementAndGet();
        } else if (this.pulled.get() > 0) {
            this.pulled.decrementAndGet();
        }
        if (this.total.get() > this.failed.get() + this.success.get()) {
            this.failed.incrementAndGet();
        }
    }

    public void decrementFailed() {
        if (this.failed.get() > 0) {
            this.failed.decrementAndGet();
        }
    }

    public String getWorkerAddr() {
        return this.workerAddr;
    }

    public int getRunning() {
        return this.running.get();
    }

    public int getPulled() {
        return this.pulled.get();
    }

    public int getSuccess() {
        return this.success.get();
    }

    public int getFailed() {
        return this.failed.get();
    }

    public int getTotal() {
        return this.total.get();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void merge(WorkerProgressCounter workerProgressCounter) {
        this.total.addAndGet(workerProgressCounter.getTotal());
        this.pulled.addAndGet(workerProgressCounter.getPulled());
        this.running.addAndGet(workerProgressCounter.getRunning());
        this.success.addAndGet(workerProgressCounter.getSuccess());
        this.failed.addAndGet(workerProgressCounter.getFailed());
    }
}

