/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.request;

import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.common.ScriptJobConfig;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.CreateJobResponse;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class CreateScriptJobRequest
extends BaseRequest<CreateJobResponse> {
    private ScriptJobConfig scriptJobConfig;

    public ScriptJobConfig getScriptJobConfig() {
        return this.scriptJobConfig;
    }

    public void setScriptJobConfig(ScriptJobConfig scriptJobConfig) {
        this.scriptJobConfig = scriptJobConfig;
        super.getParameterMap().putAll(scriptJobConfig.getParamMap());
    }

    @Override
    public Class<CreateJobResponse> getResponseClass() {
        return CreateJobResponse.class;
    }

    @Override
    public String getUrlPath() {
        return "/openapi/v1/job/create";
    }

    @Override
    public void preRun() throws RequestCheckException {
        if (this.scriptJobConfig != null) {
            ParamValidate.doValidator(this.scriptJobConfig);
            if (!this.scriptJobConfig.getExecuteMode().equals("standalone") && !this.scriptJobConfig.getExecuteMode().equals("broadcast")) {
                throw new RequestCheckException("script job execute mode only support standalone and broadcast");
            }
            if ((this.scriptJobConfig.getTimeConfig().getTimeType() == 1 || this.scriptJobConfig.getTimeConfig().getTimeType() == 3) && StringUtils.isBlank(this.scriptJobConfig.getTimeConfig().getTimeExpression())) {
                throw new RequestCheckException("cron or fix_rate timeType must set timeExpression");
            }
        } else {
            throw new RequestCheckException("scriptJobConfig is null");
        }
    }
}

