/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static String getTrace(Throwable t) {
        StringWriter result2 = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result2);
        t.printStackTrace(printWriter);
        return ((Object)result2).toString();
    }

    public static String getMessage(Throwable e) {
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() != null) {
            return e.getCause().toString();
        }
        return e.toString();
    }

    public static String buildExceptionInfo(Throwable e) {
        if (null == e) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName());
        ExceptionUtil.buildExceptionAsCause(sb, e, false);
        if (sb.length() >= 4000) {
            return sb.substring(0, 4000);
        }
        return sb.toString();
    }

    private static void buildExceptionAsCause(StringBuilder sb, Throwable e, boolean isCause) {
        StackTraceElement stackTraceElement = e.getStackTrace()[0];
        if (isCause) {
            sb.append(">>Caused by: ");
        } else {
            sb.append(">>");
        }
        sb.append(e.getLocalizedMessage()).append(" at: ");
        sb.append("[").append(stackTraceElement.toString()).append("]");
        Throwable cause = e.getCause();
        if (cause != null) {
            ExceptionUtil.buildExceptionAsCause(sb, cause, true);
        }
    }

    public static String getFixedErrMsgByThrowable(Throwable t, int maxLength) {
        String errMsg = ExceptionUtil.getTrace(t);
        if (errMsg.getBytes().length > maxLength) {
            byte[] tmp = new byte[maxLength];
            System.arraycopy(errMsg.getBytes(), 0, tmp, 0, maxLength);
            return new String(tmp);
        }
        return errMsg;
    }
}

