/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.shade.com.google.gson.Gson;
import com.alibaba.schedulerx.shade.com.google.gson.GsonBuilder;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonUtil {
    private static Gson gson = new Gson();

    public static <T> T fromJson(String json, Class<T> classOfT) throws IllegalArgumentException {
        try {
            return gson.fromJson(json, classOfT);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("json transfer failed. type:" + classOfT.getName() + "; json value:" + json);
        }
    }

    public static <T> T fromJson(String json, Type typeOfT) throws IllegalArgumentException {
        try {
            return gson.fromJson(json, typeOfT);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("json transfer failed. type:" + typeOfT + "; json value:" + json);
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> k, Class<V> v) {
        try {
            return (Map)gson.fromJson(json, TypeToken.getParameterized(Map.class, new Type[]{k, v}).getType());
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("json transfer failed. type:" + k.getName() + ":" + v.getName() + "; json value:" + json);
        }
    }

    public static String toJson(Object object, Type typeOfSrc) {
        return gson.toJson(object, typeOfSrc);
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static String toJson(Object object, boolean disableHtmlEscaping) {
        Gson gson = JsonUtil.gson;
        if (disableHtmlEscaping) {
            gson = new GsonBuilder().disableHtmlEscaping().create();
        }
        return gson.toJson(object);
    }
}

