/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class ManagementUtil {
    private static final int MAX_FRAMES = 20;

    public static int getProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
    }

    public static List<String> getStackTraces(String threadName) {
        return ManagementUtil.getStackTraces(threadName, 20);
    }

    public static List<String> getStackTraces(String threadName, int frameSize) {
        ThreadInfo[] infos;
        ArrayList<String> threadInfos = Lists.newArrayList();
        ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadMBean.dumpAllThreads(true, false)) {
            if (!info.getThreadName().contains(threadName)) continue;
            threadInfos.add(ManagementUtil.formatThreadInfo(info, frameSize, 0));
        }
        return threadInfos;
    }

    public static String formatThreadInfo(ThreadInfo info, int frameSize, int skipSize) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + info.getThreadName() + "\" Id=" + info.getThreadId() + " " + (Object)((Object)info.getThreadState()));
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (i = 0; stackTrace != null && i < stackTrace.length && i < frameSize; ++i) {
            if (i < skipSize) continue;
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : info.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append('\n');
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = info.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

