/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Attempt;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Callback;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Result;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.errors.ResultFailedException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.GroupKey;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.com.google.common.collect.EvictingQueue;
import com.alibaba.schedulerx.shade.com.google.common.collect.Iterables;
import com.alibaba.schedulerx.shade.com.google.common.util.concurrent.ListenableFuture;
import com.alibaba.schedulerx.shade.com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBatch
implements Delayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private final GroupKey groupKey;
    private final String packageId;
    private final int batchSizeThresholdInBytes;
    private final int batchCountThreshold;
    private final List<LogItem> logItems = new ArrayList<LogItem>();
    private final List<Thunk> thunks = new ArrayList<Thunk>();
    private final long createdMs;
    private long nextRetryMs;
    private int curBatchSizeInBytes;
    private int curBatchCount;
    private final EvictingQueue<Attempt> reservedAttempts;
    private int attemptCount;

    public ProducerBatch(GroupKey groupKey, String packageId, int batchSizeThresholdInBytes, int batchCountThreshold, int maxReservedAttempts, long nowMs) {
        this.groupKey = groupKey;
        this.packageId = packageId;
        this.createdMs = nowMs;
        this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
        this.batchCountThreshold = batchCountThreshold;
        this.curBatchCount = 0;
        this.curBatchSizeInBytes = 0;
        this.reservedAttempts = EvictingQueue.create(maxReservedAttempts);
        this.attemptCount = 0;
    }

    public ListenableFuture<Result> tryAppend(LogItem item, int sizeInBytes, Callback callback) {
        if (!this.hasRoomFor(sizeInBytes, 1)) {
            return null;
        }
        SettableFuture<Result> future2 = SettableFuture.create();
        this.logItems.add(item);
        this.thunks.add(new Thunk(callback, future2));
        ++this.curBatchCount;
        this.curBatchSizeInBytes += sizeInBytes;
        return future2;
    }

    public ListenableFuture<Result> tryAppend(List<LogItem> items, int sizeInBytes, Callback callback) {
        if (!this.hasRoomFor(sizeInBytes, items.size())) {
            return null;
        }
        SettableFuture<Result> future2 = SettableFuture.create();
        this.logItems.addAll(items);
        this.thunks.add(new Thunk(callback, future2));
        this.curBatchCount += items.size();
        this.curBatchSizeInBytes += sizeInBytes;
        return future2;
    }

    public void appendAttempt(Attempt attempt) {
        this.reservedAttempts.add(attempt);
        ++this.attemptCount;
    }

    public boolean isMeetSendCondition() {
        return this.curBatchSizeInBytes >= this.batchSizeThresholdInBytes || this.curBatchCount >= this.batchCountThreshold;
    }

    public long remainingMs(long nowMs, long lingerMs) {
        return lingerMs - this.createdTimeMs(nowMs);
    }

    public void fireCallbacksAndSetFutures() {
        ArrayList<Attempt> attempts = new ArrayList<Attempt>(this.reservedAttempts);
        Attempt attempt = Iterables.getLast(attempts);
        Result result2 = new Result(attempt.isSuccess(), attempts, this.attemptCount);
        this.fireCallbacks(result2);
        this.setFutures(result2);
    }

    public GroupKey getGroupKey() {
        return this.groupKey;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public List<LogItem> getLogItems() {
        return this.logItems;
    }

    public long getNextRetryMs() {
        return this.nextRetryMs;
    }

    public void setNextRetryMs(long nextRetryMs) {
        this.nextRetryMs = nextRetryMs;
    }

    public String getProject() {
        return this.groupKey.getProject();
    }

    public String getLogStore() {
        return this.groupKey.getLogStore();
    }

    public String getTopic() {
        return this.groupKey.getTopic();
    }

    public String getSource() {
        return this.groupKey.getSource();
    }

    public String getShardHash() {
        return this.groupKey.getShardHash();
    }

    public int getCurBatchSizeInBytes() {
        return this.curBatchSizeInBytes;
    }

    public int getRetries() {
        return Math.max(0, this.attemptCount - 1);
    }

    private boolean hasRoomFor(int sizeInBytes, int count2) {
        return this.curBatchSizeInBytes + sizeInBytes <= 0xA00000 && this.curBatchCount + count2 <= 40960;
    }

    private long createdTimeMs(long nowMs) {
        return Math.max(0L, nowMs - this.createdMs);
    }

    private void fireCallbacks(Result result2) {
        for (Thunk thunk : this.thunks) {
            try {
                if (thunk.callback == null) continue;
                thunk.callback.onCompletion(result2);
            }
            catch (Exception e) {
                LOGGER.error("Failed to execute user-provided callback, groupKey={}, e=", (Object)this.groupKey, (Object)e);
            }
        }
    }

    private void setFutures(Result result2) {
        for (Thunk thunk : this.thunks) {
            try {
                if (result2.isSuccessful()) {
                    thunk.future.set(result2);
                    continue;
                }
                thunk.future.setException(new ResultFailedException(result2));
            }
            catch (Exception e) {
                LOGGER.error("Failed to set future, groupKey={}, e=", (Object)this.groupKey, (Object)e);
            }
        }
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        return unit.convert(this.nextRetryMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        return (int)(this.nextRetryMs - ((ProducerBatch)o).getNextRetryMs());
    }

    public String toString() {
        return "ProducerBatch{groupKey=" + this.groupKey + ", packageId='" + this.packageId + '\'' + ", batchSizeThresholdInBytes=" + this.batchSizeThresholdInBytes + ", batchCountThreshold=" + this.batchCountThreshold + ", logItems=" + this.logItems + ", thunks=" + this.thunks + ", createdMs=" + this.createdMs + ", nextRetryMs=" + this.nextRetryMs + ", curBatchSizeInBytes=" + this.curBatchSizeInBytes + ", curBatchCount=" + this.curBatchCount + ", reservedAttempts=" + this.reservedAttempts + ", attemptCount=" + this.attemptCount + '}';
    }

    private static final class Thunk {
        final Callback callback;
        final SettableFuture<Result> future;

        Thunk(Callback callback, SettableFuture<Result> future2) {
            this.callback = callback;
            this.future = future2;
        }
    }
}

