/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DashboardBasedJobConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DingTalkNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EmailNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.MessageCenterNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Notification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.NotificationType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Query;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.SmsNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.VoiceNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.WebhookNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.internal.Unmarshaller;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.JsonUtils;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Utils;
import java.util.Date;
import java.util.List;

public class AlertConfiguration
extends DashboardBasedJobConfiguration {
    @JSONField
    private String condition;
    @JSONField
    private List<Query> queryList;
    @JSONField
    private Date muteUntil;
    @JSONField
    private Integer notifyThreshold = 1;
    @JSONField
    private String throttling;
    @JSONField
    private boolean sendRecoveryMessage;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public void setQueryList(List<Query> queryList) {
        this.queryList = queryList;
    }

    public Date getMuteUntil() {
        return this.muteUntil;
    }

    public void setMuteUntil(Date muteUntil) {
        this.muteUntil = muteUntil;
    }

    public Integer getNotifyThreshold() {
        return this.notifyThreshold;
    }

    public void setNotifyThreshold(Integer notifyThreshold) {
        this.notifyThreshold = notifyThreshold;
    }

    public String getThrottling() {
        return this.throttling;
    }

    public boolean getSendRecoveryMessage() {
        return this.sendRecoveryMessage;
    }

    public void setSendRecoveryMessage(boolean sendRecoveryMessage) {
        this.sendRecoveryMessage = sendRecoveryMessage;
    }

    public void setThrottling(String throttling) {
        Args.checkDuration(throttling);
        this.throttling = throttling;
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        this.condition = value.getString("condition");
        this.queryList = JsonUtils.readList(value, "queryList", new Unmarshaller<Query>(){

            @Override
            public Query unmarshal(JSONArray value, int index) {
                Query query = new Query();
                query.deserialize(value.getJSONObject(index));
                return query;
            }
        });
        if (value.containsKey((Object)"muteUntil")) {
            this.muteUntil = Utils.timestampToDate(value.getLong("muteUntil"));
        }
        this.notifyThreshold = JsonUtils.readOptionalInt(value, "notifyThreshold");
        this.throttling = JsonUtils.readOptionalString(value, "throttling");
        this.sendRecoveryMessage = JsonUtils.readBool(value, "sendRecoveryMessage", false);
    }

    @Override
    Notification makeQualifiedNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
            case MESSAGE_CENTER: {
                return new MessageCenterNotification();
            }
            case SMS: {
                return new SmsNotification();
            }
            case WEBHOOK: {
                return new WebhookNotification();
            }
            case VOICE: {
                return new VoiceNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented notification type: " + (Object)((Object)type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertConfiguration that = (AlertConfiguration)o;
        if (this.sendRecoveryMessage != that.sendRecoveryMessage) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.queryList != null ? !this.queryList.equals(that.queryList) : that.queryList != null) {
            return false;
        }
        if (this.muteUntil != null ? !this.muteUntil.equals(that.muteUntil) : that.muteUntil != null) {
            return false;
        }
        if (this.notifyThreshold != null ? !this.notifyThreshold.equals(that.notifyThreshold) : that.notifyThreshold != null) {
            return false;
        }
        return this.throttling != null ? this.throttling.equals(that.throttling) : that.throttling == null;
    }

    public int hashCode() {
        int result2 = this.condition != null ? this.condition.hashCode() : 0;
        result2 = 31 * result2 + (this.queryList != null ? this.queryList.hashCode() : 0);
        result2 = 31 * result2 + (this.muteUntil != null ? this.muteUntil.hashCode() : 0);
        result2 = 31 * result2 + (this.notifyThreshold != null ? this.notifyThreshold.hashCode() : 0);
        result2 = 31 * result2 + (this.throttling != null ? this.throttling.hashCode() : 0);
        result2 = 31 * result2 + (this.sendRecoveryMessage ? 1 : 0);
        return result2;
    }
}

