/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class EtlMeta
implements Serializable {
    private static final long serialVersionUID = -4940373026567060213L;
    private String metaName = null;
    private String metaKey = null;
    private String metaTag = null;
    private JSONObject metaValue = null;
    private long createTime;
    private long lastModifyTime;
    private boolean enable;

    public EtlMeta() {
        this.enable = true;
    }

    public EtlMeta(String metaName, String metaKey, String metaTag) {
        this.metaName = metaName;
        this.metaKey = metaKey;
        this.metaTag = metaTag;
        this.enable = true;
    }

    public EtlMeta(String metaName, String metaKey, String metaTag, JSONObject metaValue, boolean enable) {
        this.metaName = metaName;
        this.metaKey = metaKey;
        this.metaTag = metaTag;
        this.metaValue = metaValue;
        this.enable = enable;
    }

    public EtlMeta(String metaName, String metaKey, boolean enable) {
        this.metaName = metaName;
        this.metaKey = metaKey;
        this.enable = enable;
    }

    public void setMetaName(String metaName) {
        this.metaName = metaName;
    }

    public void setMetaKey(String metaKey) {
        this.metaKey = metaKey;
    }

    public void setMetaTag(String metaTag) {
        this.metaTag = metaTag;
    }

    public void setMetaValue(JSONObject metaValue) {
        this.metaValue = metaValue;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getMetaName() {
        return this.metaName;
    }

    public String getMetaKey() {
        return this.metaKey;
    }

    public String getMetaTag() {
        return this.metaTag;
    }

    public JSONObject getMetaValue() {
        return this.metaValue;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public JSONObject toJsonObject() {
        JSONObject etlMetaJson = new JSONObject();
        etlMetaJson.put("etlMetaName", (Object)this.metaName);
        etlMetaJson.put("etlMetaKey", (Object)this.metaKey);
        if (this.metaTag != null) {
            etlMetaJson.put("etlMetaTag", (Object)this.metaTag);
        }
        if (this.metaValue != null) {
            etlMetaJson.put("etlMetaValue", (Object)this.metaValue);
        }
        etlMetaJson.put("enable", (Object)this.enable);
        return etlMetaJson;
    }

    public void fromJsonObject(JSONObject etlMetaJson) throws LogException {
        try {
            this.metaName = etlMetaJson.getString("etlMetaName");
            this.metaKey = etlMetaJson.getString("etlMetaKey");
            this.metaTag = etlMetaJson.getString("etlMetaTag");
            String value = etlMetaJson.getString("etlMetaValue");
            this.metaValue = JSONObject.parseObject((String)value.trim());
            this.createTime = etlMetaJson.containsKey((Object)"createTime") ? etlMetaJson.getLong("createTime") : 0L;
            this.lastModifyTime = etlMetaJson.containsKey((Object)"lastModifyTime") ? etlMetaJson.getLong("lastModifyTime") : 0L;
            this.enable = etlMetaJson.containsKey((Object)"enable") ? etlMetaJson.getBoolean("enable") : true;
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", e.getMessage(), e, "");
        }
    }

    public void checkForCreate() throws IllegalArgumentException {
        if (this.metaName == null || this.metaKey == null || this.metaTag == null || this.metaValue == null) {
            throw new IllegalArgumentException("metaName/metaKey/metaTag/metaValue is uninitialized");
        }
    }

    public void checkForUpdate() throws IllegalArgumentException {
        if (this.metaName == null || this.metaKey == null) {
            throw new IllegalArgumentException("metaName/metaKey is uninitialized");
        }
    }
}

