/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class GroupAttribute
implements Serializable {
    private static final long serialVersionUID = -537679331882943768L;
    private String externalName = "";
    private String groupTopic = "";

    public GroupAttribute() {
    }

    public GroupAttribute(String externalName, String groupTopic) {
        this.externalName = externalName;
        this.groupTopic = groupTopic;
    }

    public GroupAttribute(GroupAttribute groupAttribute) {
        this.externalName = groupAttribute.GetExternalName();
        this.groupTopic = groupAttribute.GetGroupTopic();
    }

    public String GetExternalName() {
        return this.externalName;
    }

    public void SetExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String GetGroupTopic() {
        return this.groupTopic;
    }

    public void SetGroupTopic(String groupTopic) {
        this.groupTopic = groupTopic;
    }

    public JSONObject ToJsonObject() {
        JSONObject groupAttributeDict = new JSONObject();
        groupAttributeDict.put("groupTopic", (Object)this.GetGroupTopic());
        groupAttributeDict.put("externalName", (Object)this.GetExternalName());
        return groupAttributeDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject groupAttribute) throws LogException {
        try {
            this.externalName = groupAttribute.getString("externalName");
            this.groupTopic = groupAttribute.getString("groupTopic");
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateGroupAttribute", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String groupAttributeString) throws LogException {
        try {
            JSONObject groupAttribute = JSONObject.parseObject((String)groupAttributeString);
            this.FromJsonObject(groupAttribute);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateGroupAttribute", e.getMessage(), e, "");
        }
    }
}

