/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AliyunBSSSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AliyunCloudMonitorSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AliyunMaxComputeSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AliyunOSSSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DataSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DataSourceType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JDBCSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.KafKaSource;

public class IngestionConfiguration
extends JobConfiguration {
    private String logstore;
    private DataSource source;
    private Integer numberOfInstances;

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public DataSource getSource() {
        return this.source;
    }

    public void setSource(DataSource source) {
        this.source = source;
    }

    public Integer getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(Integer numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    private DataSource createSource(DataSourceType type) {
        switch (type) {
            case JDBC: {
                return new JDBCSource();
            }
            case ALIYUN_BSS: {
                return new AliyunBSSSource();
            }
            case ALIYUN_OSS: {
                return new AliyunOSSSource();
            }
            case ALIYUN_MAX_COMPUTE: {
                return new AliyunMaxComputeSource();
            }
            case KAFKA: {
                return new KafKaSource();
            }
            case ALIYUN_CLOUD_MONITOR: {
                return new AliyunCloudMonitorSource();
            }
        }
        return null;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.logstore = value.getString("logstore");
        this.numberOfInstances = value.getIntValue("numberOfInstances");
        JSONObject jsonObject = value.getJSONObject("source");
        DataSourceType kind = DataSourceType.fromString(jsonObject.getString("type"));
        this.source = this.createSource(kind);
        if (this.source != null) {
            this.source.deserialize(jsonObject);
        }
    }
}

