/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import java.io.Serializable;

public class LogStore
implements Serializable {
    private static final long serialVersionUID = 7408057477332043832L;
    private String logStoreName = "";
    private int ttl = -1;
    private int shardCount = -1;
    private boolean enableWebTracking = false;
    private boolean appendMeta = false;
    private boolean mAutoSplit = false;
    private int mMaxSplitShard = -1;
    private int createTime = -1;
    private int lastModifyTime = -1;
    private long preserveStorage = -1L;
    private long usedStorage = 0L;
    private String productType = "";
    private int archiveSeconds = 0;
    private String telemetryType = "";

    public int getArchiveSeconds() {
        return this.archiveSeconds;
    }

    public void setArchiveSeconds(int archiveSeconds) {
        this.archiveSeconds = archiveSeconds;
    }

    public String getTelemetryType() {
        return this.telemetryType;
    }

    public void setTelemetryType(String telemetryType) {
        this.telemetryType = telemetryType;
    }

    public String getProductType() {
        return this.productType;
    }

    public LogStore() {
    }

    public LogStore(String logStoreName, int ttl, int shardCount) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
    }

    public LogStore(String logStoreName, int ttl, int shardCount, boolean enableWebTracking) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
        this.enableWebTracking = enableWebTracking;
    }

    public LogStore(LogStore logStore) {
        Args.notNull(logStore, "LogStore must not be null");
        this.logStoreName = logStore.GetLogStoreName();
        this.ttl = logStore.GetTtl();
        this.shardCount = logStore.GetShardCount();
        this.createTime = logStore.GetCreateTime();
        this.lastModifyTime = logStore.GetLastModifyTime();
        this.enableWebTracking = logStore.isEnableWebTracking();
        this.appendMeta = logStore.isAppendMeta();
        this.mAutoSplit = logStore.ismAutoSplit();
        this.mMaxSplitShard = logStore.getmMaxSplitShard();
        this.preserveStorage = logStore.preserveStorage;
        this.usedStorage = logStore.usedStorage;
        this.productType = logStore.getProductType();
        this.archiveSeconds = logStore.getArchiveSeconds();
        this.telemetryType = logStore.getTelemetryType();
    }

    public long getPreserveStorage() {
        return this.preserveStorage;
    }

    public void setPreserveStorage(long preserveStorage) {
        this.preserveStorage = preserveStorage;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public void setUsedStorage(long usedStorage) {
        this.usedStorage = usedStorage;
    }

    public int getmMaxSplitShard() {
        return this.mMaxSplitShard;
    }

    public void setmMaxSplitShard(int mMaxSplitShard) {
        this.mMaxSplitShard = mMaxSplitShard;
    }

    public boolean ismAutoSplit() {
        return this.mAutoSplit;
    }

    public void setmAutoSplit(boolean mAutoSplit) {
        this.mAutoSplit = mAutoSplit;
    }

    public boolean isEnableWebTracking() {
        return this.enableWebTracking;
    }

    public void setEnableWebTracking(boolean enableWebTracking) {
        this.enableWebTracking = enableWebTracking;
    }

    public boolean isAppendMeta() {
        return this.appendMeta;
    }

    public void setAppendMeta(boolean appendMeta) {
        this.appendMeta = appendMeta;
    }

    public String GetLogStoreName() {
        return this.logStoreName;
    }

    public int GetTtl() {
        return this.ttl;
    }

    public int GetShardCount() {
        return this.shardCount;
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public void SetLogStoreName(String logStoreName) {
        this.logStoreName = logStoreName;
    }

    public void SetTtl(int ttl) {
        this.ttl = ttl;
    }

    public void SetShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public JSONObject ToRequestJson() {
        JSONObject logStoreDict = new JSONObject();
        logStoreDict.put("logstoreName", (Object)this.GetLogStoreName());
        logStoreDict.put("ttl", (Object)this.GetTtl());
        logStoreDict.put("shardCount", (Object)this.GetShardCount());
        logStoreDict.put("enable_tracking", (Object)this.isEnableWebTracking());
        logStoreDict.put("autoSplit", (Object)this.ismAutoSplit());
        logStoreDict.put("maxSplitShard", (Object)this.getmMaxSplitShard());
        logStoreDict.put("appendMeta", (Object)this.isAppendMeta());
        JSONObject resourceQuota = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("preserved", (Object)this.preserveStorage);
        resourceQuota.put("storage", (Object)storage);
        logStoreDict.put("resourceQuota", (Object)resourceQuota);
        logStoreDict.put("archiveSeconds", (Object)this.archiveSeconds);
        logStoreDict.put("telemetryType", (Object)this.telemetryType);
        return logStoreDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject logStoreDict = this.ToRequestJson();
        logStoreDict.put("createTime", (Object)this.GetCreateTime());
        logStoreDict.put("lastModifyTime", (Object)this.GetLastModifyTime());
        return logStoreDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            JSONObject resourceQuotaJson;
            this.SetLogStoreName(dict.getString("logstoreName"));
            this.SetTtl(dict.getIntValue("ttl"));
            this.SetShardCount(dict.getIntValue("shardCount"));
            if (dict.containsKey((Object)"enable_tracking")) {
                this.setEnableWebTracking(dict.getBoolean("enable_tracking"));
            }
            if (dict.containsKey((Object)"createTime")) {
                this.createTime = dict.getIntValue("createTime");
            }
            if (dict.containsKey((Object)"lastModifyTime")) {
                this.lastModifyTime = dict.getIntValue("lastModifyTime");
            }
            if (dict.containsKey((Object)"autoSplit")) {
                this.mAutoSplit = dict.getBoolean("autoSplit");
            }
            if (dict.containsKey((Object)"maxSplitShard")) {
                this.mMaxSplitShard = dict.getIntValue("maxSplitShard");
            }
            boolean bl = this.appendMeta = dict.containsKey((Object)"appendMeta") && dict.getBoolean("appendMeta") != false;
            if (dict.containsKey((Object)"productType")) {
                this.productType = dict.getString("productType");
            }
            if (dict.containsKey((Object)"archiveSeconds")) {
                this.archiveSeconds = dict.getIntValue("archiveSeconds");
            }
            if (dict.containsKey((Object)"telemetryType")) {
                this.telemetryType = dict.getString("telemetryType");
            }
            if (dict.containsKey((Object)"resourceQuota") && (resourceQuotaJson = dict.getJSONObject("resourceQuota")).containsKey((Object)"storage")) {
                JSONObject storageJson = resourceQuotaJson.getJSONObject("storage");
                if (storageJson.containsKey((Object)"preserved")) {
                    this.preserveStorage = storageJson.getLong("preserved");
                }
                if (storageJson.containsKey((Object)"used")) {
                    this.usedStorage = storageJson.getLong("used");
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String logStoreString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject((String)logStoreString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }
}

