/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.sample;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Logging;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LoggingDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Project;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.CreateLoggingRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.UpdateLoggingRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.ListProjectResponse;
import java.util.ArrayList;

public class LoggingSample {
    private static final String PROJECT_TO_STORE_LOG = "";
    private static final String ACCESS_KEY = "";
    private static final String ACCESS_KEY_SECRET = "";
    private static final String ENDPOINT = "";

    public static void main(String[] args) throws Exception {
        Client client = new Client("", "", "");
        ListProjectResponse response = client.ListProject();
        String[] logTypes = new String[]{"operation_log", "metering", "consumergroup_log", "logtail_alarm", "logtail_profile", "logtail_status"};
        for (Project project : response.getProjects()) {
            System.out.println(project.getProjectName());
            String projectName = project.getProjectName();
            ArrayList<LoggingDetail> logListToEnable = new ArrayList<LoggingDetail>();
            for (String logType : logTypes) {
                String logstoreToSaveLog = logType.equals("operation_log") ? "internal-operation_log" : "internal-diagnostic_log";
                logListToEnable.add(new LoggingDetail(logType, logstoreToSaveLog));
            }
            Logging logging = new Logging("", logListToEnable);
            try {
                client.updateLogging(new UpdateLoggingRequest(projectName, logging));
            }
            catch (LogException ex) {
                if (ex.GetErrorCode().equals("LoggingNotExist")) {
                    client.createLogging(new CreateLoggingRequest(projectName, logging));
                    continue;
                }
                throw ex;
            }
        }
    }
}

