/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.io;

import com.alibaba.schedulerx.shade.com.google.common.annotations.GwtIncompatible;
import com.alibaba.schedulerx.shade.com.google.common.annotations.J2ktIncompatible;
import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.io.AppendableWriter;
import com.alibaba.schedulerx.shade.com.google.common.io.ElementTypesAreNonnullByDefault;
import com.alibaba.schedulerx.shade.com.google.common.io.Java8Compatibility;
import com.alibaba.schedulerx.shade.com.google.common.io.LineProcessor;
import com.alibaba.schedulerx.shade.com.google.common.io.LineReader;
import com.alibaba.schedulerx.shade.com.google.common.io.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class CharStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    private CharStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(Readable from2, Appendable to2) throws IOException {
        if (from2 instanceof Reader) {
            if (to2 instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)from2, (StringBuilder)to2);
            }
            return CharStreams.copyReaderToWriter((Reader)from2, CharStreams.asWriter(to2));
        }
        Preconditions.checkNotNull(from2);
        Preconditions.checkNotNull(to2);
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while (from2.read(buf) != -1) {
            Java8Compatibility.flip(buf);
            to2.append(buf);
            total += (long)buf.remaining();
            Java8Compatibility.clear(buf);
        }
        return total;
    }

    @CanIgnoreReturnValue
    static long copyReaderToBuilder(Reader from2, StringBuilder to2) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from2);
        Preconditions.checkNotNull(to2);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from2.read(buf)) != -1) {
            to2.append(buf, 0, nRead);
            total += (long)nRead;
        }
        return total;
    }

    @CanIgnoreReturnValue
    static long copyReaderToWriter(Reader from2, Writer to2) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from2);
        Preconditions.checkNotNull(to2);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from2.read(buf)) != -1) {
            to2.write(buf, 0, nRead);
            total += (long)nRead;
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        return CharStreams.toStringBuilder(r).toString();
    }

    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (r instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)r, sb);
        } else {
            CharStreams.copy(r, sb);
        }
        return sb;
    }

    public static List<String> readLines(Readable r) throws IOException {
        String line;
        ArrayList<String> result2 = new ArrayList<String>();
        LineReader lineReader = new LineReader(r);
        while ((line = lineReader.readLine()) != null) {
            result2.add(line);
        }
        return result2;
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <T> T readLines(Readable readable, LineProcessor<T> processor) throws IOException {
        String line;
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(processor);
        LineReader lineReader = new LineReader(readable);
        while ((line = lineReader.readLine()) != null && processor.processLine(line)) {
        }
        return processor.getResult();
    }

    @CanIgnoreReturnValue
    public static long exhaust(Readable readable) throws IOException {
        long read2;
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while ((read2 = (long)readable.read(buf)) != -1L) {
            total += read2;
            Java8Compatibility.clear(buf);
        }
        return total;
    }

    public static void skipFully(Reader reader, long n) throws IOException {
        Preconditions.checkNotNull(reader);
        while (n > 0L) {
            long amt = reader.skip(n);
            if (amt == 0L) {
                throw new EOFException();
            }
            n -= amt;
        }
    }

    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    public static Writer asWriter(Appendable target) {
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(target);
    }

    private static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public void write(int c) {
        }

        @Override
        public void write(char[] cbuf) {
            Preconditions.checkNotNull(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len2) {
            Preconditions.checkPositionIndexes(off, off + len2, cbuf.length);
        }

        @Override
        public void write(String str) {
            Preconditions.checkNotNull(str);
        }

        @Override
        public void write(String str, int off, int len2) {
            Preconditions.checkPositionIndexes(off, off + len2, str.length());
        }

        @Override
        public Writer append(@CheckForNull CharSequence csq) {
            return this;
        }

        @Override
        public Writer append(@CheckForNull CharSequence csq, int start2, int end) {
            Preconditions.checkPositionIndexes(start2, end, csq == null ? "null".length() : csq.length());
            return this;
        }

        @Override
        public Writer append(char c) {
            return this;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "CharStreams.nullWriter()";
        }
    }
}

