/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractHessianInput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractListDeserializer;
import com.alibaba.schedulerx.shade.hsf.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionDeserializer
extends AbstractListDeserializer {
    public static Class[] skipTypes = new Class[0];
    private final Class _type;
    private final boolean skipConstructor;

    public CollectionDeserializer(Class type) {
        this._type = type;
        this.skipConstructor = this.isInSkipList();
    }

    public Class getType() {
        return this._type;
    }

    @Override
    public Object readList(AbstractHessianInput in, int length) throws IOException {
        Collection list = this.createList();
        in.addRef(list);
        while (!in.isEnd()) {
            list.add(in.readObject());
        }
        in.readEnd();
        return list;
    }

    @Override
    public Object readLengthList(AbstractHessianInput in, int length) throws IOException {
        Collection list = this.createList();
        in.addRef(list);
        while (length > 0) {
            list.add(in.readObject());
            --length;
        }
        return list;
    }

    private Collection createList() throws IOException {
        Collection list = null;
        if (this._type == null) {
            list = new ArrayList();
        } else if (!this.skipConstructor && !this._type.isInterface()) {
            try {
                list = (Collection)this._type.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (list == null) {
            if (SortedSet.class.isAssignableFrom(this._type)) {
                list = new TreeSet();
            } else if (Set.class.isAssignableFrom(this._type)) {
                list = new HashSet();
            } else if (List.class.isAssignableFrom(this._type)) {
                list = new ArrayList();
            } else if (Collection.class.isAssignableFrom(this._type)) {
                list = new ArrayList();
            } else {
                try {
                    list = (Collection)this._type.newInstance();
                }
                catch (Exception e) {
                    throw new IOExceptionWrapper(e);
                }
            }
        }
        return list;
    }

    private boolean isInSkipList() {
        for (int i = 0; i < skipTypes.length; ++i) {
            if (skipTypes[i] != this._type) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            skipTypes = new Class[]{CollectionDeserializer.class.getClassLoader().loadClass("java.util.Collections$UnmodifiableCollection"), CollectionDeserializer.class.getClassLoader().loadClass("java.util.Collections$UnmodifiableList"), CollectionDeserializer.class.getClassLoader().loadClass("java.util.Collections$UnmodifiableMap"), CollectionDeserializer.class.getClassLoader().loadClass("java.util.Collections$UnmodifiableSet"), CollectionDeserializer.class.getClassLoader().loadClass("java.util.Arrays$ArrayList")};
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

