/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration;

import com.alibaba.schedulerx.shade.org.apache.commons.configuration.ConfigurationException;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.PropertiesConfiguration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringEscapeUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertiesConfiguration
extends PropertiesConfiguration {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MALFORMED_XML_EXCEPTION = "Malformed XML";

    public XMLPropertiesConfiguration() {
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setEncoding(DEFAULT_ENCODING);
    }

    public XMLPropertiesConfiguration(Element element) throws ConfigurationException {
        this.setEncoding(DEFAULT_ENCODING);
        this.load(element);
    }

    @Override
    public void load(Reader in) throws ConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(true);
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(this.getClass().getClassLoader().getResourceAsStream("properties.dtd"));
                }
            });
            xmlReader.setContentHandler(new XMLPropertiesHandler());
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to parse the configuration file", e);
        }
    }

    public void load(Element element) throws ConfigurationException {
        if (!element.getNodeName().equals("properties")) {
            throw new ConfigurationException(MALFORMED_XML_EXCEPTION);
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element)) continue;
            if (item.getNodeName().equals("comment")) {
                this.setHeader(item.getTextContent());
                continue;
            }
            if (item.getNodeName().equals("entry")) {
                String key = ((Element)item).getAttribute("key");
                this.addProperty(key, item.getTextContent());
                continue;
            }
            throw new ConfigurationException(MALFORMED_XML_EXCEPTION);
        }
    }

    @Override
    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        String encoding = this.getEncoding() != null ? this.getEncoding() : DEFAULT_ENCODING;
        writer.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        writer.println("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">");
        writer.println("<properties>");
        if (this.getHeader() != null) {
            writer.println("  <comment>" + StringEscapeUtils.escapeXml(this.getHeader()) + "</comment>");
        }
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = this.getProperty(key);
            if (value instanceof List) {
                this.writeProperty(writer, key, (List)value);
                continue;
            }
            this.writeProperty(writer, key, value);
        }
        writer.println("</properties>");
        writer.flush();
    }

    private void writeProperty(PrintWriter out, String key, Object value) {
        String k = StringEscapeUtils.escapeXml(key);
        if (value != null) {
            String v = StringEscapeUtils.escapeXml(String.valueOf(value));
            v = StringUtils.replace(v, String.valueOf(this.getListDelimiter()), "\\" + this.getListDelimiter());
            out.println("  <entry key=\"" + k + "\">" + v + "</entry>");
        } else {
            out.println("  <entry key=\"" + k + "\"/>");
        }
    }

    private void writeProperty(PrintWriter out, String key, List<?> values2) {
        for (Object value : values2) {
            this.writeProperty(out, key, value);
        }
    }

    public void save(Document document, Node parent) {
        Element properties = document.createElement("properties");
        parent.appendChild(properties);
        if (this.getHeader() != null) {
            Element comment = document.createElement("comment");
            properties.appendChild(comment);
            comment.setTextContent(StringEscapeUtils.escapeXml(this.getHeader()));
        }
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = this.getProperty(key);
            if (value instanceof List) {
                this.writeProperty(document, (Node)properties, key, (List)value);
                continue;
            }
            this.writeProperty(document, (Node)properties, key, value);
        }
    }

    private void writeProperty(Document document, Node properties, String key, Object value) {
        Element entry = document.createElement("entry");
        properties.appendChild(entry);
        String k = StringEscapeUtils.escapeXml(key);
        entry.setAttribute("key", k);
        if (value != null) {
            String v = StringEscapeUtils.escapeXml(String.valueOf(value));
            v = StringUtils.replace(v, String.valueOf(this.getListDelimiter()), "\\" + this.getListDelimiter());
            entry.setTextContent(v);
        }
    }

    private void writeProperty(Document document, Node properties, String key, List<?> values2) {
        for (Object value : values2) {
            this.writeProperty(document, properties, key, value);
        }
    }

    private class XMLPropertiesHandler
    extends DefaultHandler {
        private String key;
        private StringBuilder value = new StringBuilder();
        private boolean inCommentElement;
        private boolean inEntryElement;

        private XMLPropertiesHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            if ("comment".equals(qName)) {
                this.inCommentElement = true;
            }
            if ("entry".equals(qName)) {
                this.key = attrs.getValue("key");
                this.inEntryElement = true;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.inCommentElement) {
                XMLPropertiesConfiguration.this.setHeader(this.value.toString());
                this.inCommentElement = false;
            }
            if (this.inEntryElement) {
                XMLPropertiesConfiguration.this.addProperty(this.key, this.value.toString());
                this.inEntryElement = false;
            }
            this.value = new StringBuilder();
        }

        public void characters(char[] chars, int start2, int length) {
            this.value.append(chars, start2, length);
        }
    }
}

