/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree;

import com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import java.io.PrintStream;
import java.util.Iterator;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void printTree(PrintStream stream, ConfigurationNode result2) {
        if (stream != null) {
            TreeUtils.printTree(stream, "", result2);
        }
    }

    private static void printTree(PrintStream stream, String indent, ConfigurationNode result2) {
        StringBuffer buffer = new StringBuffer(indent).append("<").append(result2.getName());
        for (ConfigurationNode node : result2.getAttributes()) {
            buffer.append(" ").append(node.getName()).append("='").append(node.getValue()).append("'");
        }
        buffer.append(">");
        stream.print(buffer.toString());
        if (result2.getValue() != null) {
            stream.print(result2.getValue());
        }
        boolean newline = false;
        if (result2.getChildrenCount() > 0) {
            stream.print("\n");
            Iterator<ConfigurationNode> iter2 = result2.getChildren().iterator();
            while (iter2.hasNext()) {
                TreeUtils.printTree(stream, indent + "  ", iter2.next());
            }
            newline = true;
        }
        if (newline) {
            stream.print(indent);
        }
        stream.println("</" + result2.getName() + ">");
    }
}

