/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.client.methods;

import com.alibaba.schedulerx.shade.org.apache.http.HttpEntityEnclosingRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpHost;
import com.alibaba.schedulerx.shade.org.apache.http.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpDelete;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpGet;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpHead;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpOptions;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPost;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPut;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpTrace;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpUriRequest;
import com.alibaba.schedulerx.shade.org.apache.http.client.utils.URIUtils;
import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.nio.client.methods.ZeroCopyConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.client.methods.ZeroCopyPost;
import com.alibaba.schedulerx.shade.org.apache.http.nio.client.methods.ZeroCopyPut;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.HttpAsyncContentProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.NByteArrayEntity;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.NStringEntity;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public final class HttpAsyncMethods {
    public static HttpAsyncRequestProducer create(HttpHost target, HttpRequest request) {
        Args.notNull(target, "HTTP host");
        Args.notNull(request, "HTTP request");
        return new RequestProducerImpl(target, request);
    }

    public static HttpAsyncRequestProducer create(HttpUriRequest request) {
        Args.notNull(request, "HTTP request");
        HttpHost target = URIUtils.extractHost(request.getURI());
        return new RequestProducerImpl(target, request);
    }

    public static HttpAsyncRequestProducer createGet(URI requestURI) {
        return HttpAsyncMethods.create(new HttpGet(requestURI));
    }

    public static HttpAsyncRequestProducer createGet(String requestURI) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createHead(URI requestURI) {
        return HttpAsyncMethods.create(new HttpHead(requestURI));
    }

    public static HttpAsyncRequestProducer createHead(String requestURI) {
        return HttpAsyncMethods.create(new HttpHead(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createDelete(URI requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(requestURI));
    }

    public static HttpAsyncRequestProducer createDelete(String requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createOptions(URI requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(requestURI));
    }

    public static HttpAsyncRequestProducer createOptions(String requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createTrace(URI requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(requestURI));
    }

    public static HttpAsyncRequestProducer createTrace(String requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        HttpPost httppost = new HttpPost(requestURI);
        NStringEntity entity = new NStringEntity(content, contentType);
        httppost.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, byte[] content, ContentType contentType) {
        HttpPost httppost = new HttpPost(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content, contentType);
        httppost.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, byte[] content, ContentType contentType) {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        HttpPut httpput = new HttpPut(requestURI);
        NStringEntity entity = new NStringEntity(content, contentType);
        httpput.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, byte[] content, ContentType contentType) {
        HttpPut httpput = new HttpPut(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content, contentType);
        httpput.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, byte[] content, ContentType contentType) {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(URI requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(requestURI, content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(String requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(URI requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(requestURI, content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(String requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createConsumer() {
        return new BasicAsyncResponseConsumer();
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createZeroCopyConsumer(File file) throws FileNotFoundException {
        return new ZeroCopyConsumer<HttpResponse>(file){

            @Override
            protected HttpResponse process(HttpResponse response, File file, ContentType contentType) {
                return response;
            }
        };
    }

    static class RequestProducerImpl
    extends BasicAsyncRequestProducer {
        protected RequestProducerImpl(HttpHost target, HttpEntityEnclosingRequest request, HttpAsyncContentProducer producer) {
            super(target, request, producer);
        }

        public RequestProducerImpl(HttpHost target, HttpRequest request) {
            super(target, request);
        }
    }
}

