/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.schema.SchemaObject;
import java.util.ArrayList;

public class AlterSchemaRename
extends DefineCommand {
    private Schema oldSchema;
    private String newSchemaName;

    public AlterSchemaRename(Session session) {
        super(session);
    }

    public void setOldSchema(Schema schema) {
        this.oldSchema = schema;
    }

    public void setNewName(String string2) {
        this.newSchemaName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (!this.oldSchema.canDrop()) {
            throw DbException.get(90090, this.oldSchema.getName());
        }
        if (database.findSchema(this.newSchemaName) != null || this.newSchemaName.equals(this.oldSchema.getName())) {
            throw DbException.get(90078, this.newSchemaName);
        }
        this.session.getUser().checkSchemaAdmin();
        database.renameDatabaseObject(this.session, this.oldSchema, this.newSchemaName);
        ArrayList<SchemaObject> arrayList = database.getAllSchemaObjects();
        for (SchemaObject schemaObject : arrayList) {
            database.updateMeta(this.session, schemaObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 2;
    }
}

