/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.TableLink;

public class CreateLinkedTable
extends SchemaCommand {
    private String tableName;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalSchema;
    private String originalTable;
    private boolean ifNotExists;
    private String comment;
    private boolean emitUpdates;
    private boolean force;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean readOnly;

    public CreateLinkedTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTableName(String string2) {
        this.tableName = string2;
    }

    public void setDriver(String string2) {
        this.driver = string2;
    }

    public void setOriginalTable(String string2) {
        this.originalTable = string2;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setUrl(String string2) {
        this.url = string2;
    }

    public void setUser(String string2) {
        this.user = string2;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (this.getSchema().resolveTableOrView(this.session, this.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.tableName);
        }
        int n = this.getObjectId();
        TableLink tableLink = this.getSchema().createTableLink(n, this.tableName, this.driver, this.url, this.user, this.password, this.originalSchema, this.originalTable, this.emitUpdates, this.force);
        tableLink.setTemporary(this.temporary);
        tableLink.setGlobalTemporary(this.globalTemporary);
        tableLink.setComment(this.comment);
        tableLink.setReadOnly(this.readOnly);
        if (this.temporary && !this.globalTemporary) {
            this.session.addLocalTempTable(tableLink);
        } else {
            database.addSchemaObject(this.session, tableLink);
        }
        return 0;
    }

    public void setEmitUpdates(boolean bl) {
        this.emitUpdates = bl;
    }

    public void setComment(String string2) {
        this.comment = string2;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setOriginalSchema(String string2) {
        this.originalSchema = string2;
    }

    @Override
    public int getType() {
        return 26;
    }
}

