/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.AggregateData;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.index.Cursor;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.result.SearchRow;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.IndexColumn;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDate;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDecimal;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDouble;
import com.alibaba.schedulerx.shade.org.h2.value.ValueFloat;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTime;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestamp;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestampTimeZone;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;

class AggregateDataMedian
extends AggregateData {
    private Collection<Value> values;

    AggregateDataMedian() {
    }

    private static boolean isNullsLast(Index index) {
        IndexColumn indexColumn = index.getIndexColumns()[0];
        int n = indexColumn.sortType;
        return (n & 4) != 0 || (n & 1) != 0 && (n & 2) == 0;
    }

    static Index getMedianColumnIndex(Expression expression) {
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                ArrayList<Index> arrayList = table.getIndexes();
                Index index = null;
                if (arrayList != null) {
                    boolean bl = column.isNullable();
                    int n = arrayList.size();
                    for (int i = 1; i < n; ++i) {
                        Index index2 = arrayList.get(i);
                        if (!index2.canFindNext() || !index2.isFirstColumn(column) || index != null && index.getColumns().length <= index2.getColumns().length && (!bl || !AggregateDataMedian.isNullsLast(index) || AggregateDataMedian.isNullsLast(index2))) continue;
                        index = index2;
                    }
                }
                return index;
            }
        }
        return null;
    }

    static Value getResultFromIndex(Session session, Expression expression, int n) {
        Object object;
        Object object2;
        Index index = AggregateDataMedian.getMedianColumnIndex(expression);
        long l = index.getRowCount(session);
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        Cursor cursor = index.find(session, null, null);
        cursor.next();
        int n2 = index.getColumns()[0].getColumnId();
        ExpressionColumn expressionColumn = (ExpressionColumn)expression;
        if (expressionColumn.getColumn().isNullable()) {
            boolean bl = false;
            while (l > 0L) {
                SearchRow searchRow = cursor.getSearchRow();
                if (searchRow == null) {
                    return ValueNull.INSTANCE;
                }
                if (searchRow.getValue(n2) != ValueNull.INSTANCE) break;
                --l;
                cursor.next();
                bl = true;
            }
            if (l == 0L) {
                return ValueNull.INSTANCE;
            }
            if (!bl && AggregateDataMedian.isNullsLast(index)) {
                TableFilter tableFilter = expressionColumn.getTableFilter();
                object2 = tableFilter.getTable().getTemplateSimpleRow(true);
                object2.setValue(n2, ValueNull.INSTANCE);
                object = index.find(session, (SearchRow)object2, (SearchRow)object2);
                while (object.next()) {
                    --l;
                }
                if (l <= 0L) {
                    return ValueNull.INSTANCE;
                }
            }
        }
        long l2 = (l - 1L) / 2L;
        int n3 = 0;
        while ((long)n3 < l2) {
            cursor.next();
            ++n3;
        }
        SearchRow searchRow = cursor.getSearchRow();
        if (searchRow == null) {
            return ValueNull.INSTANCE;
        }
        object2 = searchRow.getValue(n2);
        if (object2 == ValueNull.INSTANCE) {
            return object2;
        }
        if ((l & 1L) == 0L) {
            cursor.next();
            searchRow = cursor.getSearchRow();
            if (searchRow == null) {
                return object2;
            }
            object = searchRow.getValue(n2);
            if (object == ValueNull.INSTANCE) {
                return object2;
            }
            return AggregateDataMedian.getMedian((Value)object2, (Value)object, n, session.getDatabase().getCompareMode());
        }
        return object2;
    }

    @Override
    void add(Database database, int n, boolean bl, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        Collection<Value> collection = this.values;
        if (collection == null) {
            collection = bl ? new HashSet() : new ArrayList();
            this.values = collection;
        }
        collection.add(value);
    }

    @Override
    Value getValue(Database database, int n, boolean bl) {
        Collection<Value> collection = this.values;
        if (collection == null) {
            return ValueNull.INSTANCE;
        }
        if (bl && collection instanceof ArrayList) {
            collection = new HashSet<Value>(collection);
        }
        Value[] valueArray = collection.toArray(new Value[0]);
        final CompareMode compareMode = database.getCompareMode();
        Arrays.sort(valueArray, new Comparator<Value>(){

            @Override
            public int compare(Value value, Value value2) {
                return value.compareTo(value2, compareMode);
            }
        });
        int n2 = valueArray.length;
        int n3 = n2 / 2;
        Value value = valueArray[n3];
        if ((n2 & 1) == 1) {
            return value.convertTo(n);
        }
        return AggregateDataMedian.getMedian(valueArray[n3 - 1], value, n, compareMode);
    }

    private static Value getMedian(Value value, Value value2, int n, CompareMode compareMode) {
        if (value.compareTo(value2, compareMode) == 0) {
            return value.convertTo(n);
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                return ValueInt.get((value.getInt() + value2.getInt()) / 2).convertTo(n);
            }
            case 5: {
                return ValueLong.get((value.getLong() + value2.getLong()) / 2L);
            }
            case 6: {
                return ValueDecimal.get(value.getBigDecimal().add(value2.getBigDecimal()).divide(BigDecimal.valueOf(2L)));
            }
            case 8: {
                return ValueFloat.get((value.getFloat() + value2.getFloat()) / 2.0f);
            }
            case 7: {
                return ValueDouble.get(((double)value.getFloat() + value2.getDouble()) / 2.0);
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value.convertTo(9);
                ValueTime valueTime2 = (ValueTime)value2.convertTo(9);
                return ValueTime.fromNanos((valueTime.getNanos() + valueTime2.getNanos()) / 2L);
            }
            case 10: {
                ValueDate valueDate = (ValueDate)value.convertTo(10);
                ValueDate valueDate2 = (ValueDate)value2.convertTo(10);
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay((DateTimeUtils.absoluteDayFromDateValue(valueDate.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(valueDate2.getDateValue())) / 2L));
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
                ValueTimestamp valueTimestamp2 = (ValueTimestamp)value2.convertTo(11);
                long l = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(valueTimestamp2.getDateValue());
                long l2 = (valueTimestamp.getTimeNanos() + valueTimestamp2.getTimeNanos()) / 2L;
                if ((l & 1L) != 0L && (l2 += 43200000000000L) >= 86400000000000L) {
                    l2 -= 86400000000000L;
                    ++l;
                }
                return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l / 2L), l2);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24);
                ValueTimestampTimeZone valueTimestampTimeZone2 = (ValueTimestampTimeZone)value2.convertTo(24);
                long l = DateTimeUtils.absoluteDayFromDateValue(valueTimestampTimeZone.getDateValue()) + DateTimeUtils.absoluteDayFromDateValue(valueTimestampTimeZone2.getDateValue());
                long l3 = (valueTimestampTimeZone.getTimeNanos() + valueTimestampTimeZone2.getTimeNanos()) / 2L;
                int n2 = valueTimestampTimeZone.getTimeZoneOffsetMins() + valueTimestampTimeZone2.getTimeZoneOffsetMins();
                if ((l & 1L) != 0L) {
                    l3 += 43200000000000L;
                }
                if ((n2 & 1) != 0) {
                    l3 += 30000000000L;
                }
                if (l3 >= 86400000000000L) {
                    l3 -= 86400000000000L;
                    ++l;
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l / 2L), l3, (short)(n2 / 2));
            }
        }
        return value.convertTo(n);
    }
}

