/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Mode;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.Function;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import com.alibaba.schedulerx.shade.org.h2.value.ValueString;

public class Operation
extends Expression {
    private OpType opType;
    private Expression left;
    private Expression right;
    private int dataType;
    private boolean convertRight = true;

    public Operation(OpType opType, Expression expression, Expression expression2) {
        this.opType = opType;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public String getSQL() {
        String string2 = this.opType == OpType.NEGATE ? "- " + this.left.getSQL() : this.left.getSQL() + " " + this.getOperationToken() + " " + this.right.getSQL();
        return "(" + string2 + ")";
    }

    private String getOperationToken() {
        switch (this.opType) {
            case NEGATE: {
                return "-";
            }
            case CONCAT: {
                return "||";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Value value;
        Value value2 = this.left.getValue(session).convertTo(this.dataType);
        if (this.right == null) {
            value = null;
        } else {
            value = this.right.getValue(session);
            if (this.convertRight) {
                value = value.convertTo(this.dataType);
            }
        }
        switch (this.opType) {
            case NEGATE: {
                return value2 == ValueNull.INSTANCE ? value2 : value2.negate();
            }
            case CONCAT: {
                Mode mode = session.getDatabase().getMode();
                if (value2 == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value;
                }
                if (value == ValueNull.INSTANCE) {
                    if (mode.nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return value2;
                }
                String string2 = value2.getString();
                String string3 = value.getString();
                StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length());
                stringBuilder.append(string2).append(string3);
                return ValueString.get(stringBuilder.toString());
            }
            case PLUS: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.add(value);
            }
            case MINUS: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.subtract(value);
            }
            case MULTIPLY: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.multiply(value);
            }
            case DIVIDE: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.divide(value);
            }
            case MODULUS: {
                if (value2 == ValueNull.INSTANCE || value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value2.modulus(value);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        switch (this.opType) {
            case NEGATE: {
                this.dataType = this.left.getType();
                if (this.dataType != -1) break;
                this.dataType = 6;
                break;
            }
            case CONCAT: {
                this.right = this.right.optimize(session);
                this.dataType = 13;
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                this.right = this.right.optimize(session);
                int n = this.left.getType();
                int n2 = this.right.getType();
                if (n == 0 && n2 == 0 || n == -1 && n2 == -1) {
                    if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                        this.dataType = 13;
                        this.opType = OpType.CONCAT;
                        break;
                    }
                    this.dataType = 6;
                    break;
                }
                if (n == 10 || n == 11 || n == 9 || n2 == 10 || n2 == 11 || n2 == 9) {
                    if (this.opType == OpType.PLUS) {
                        if (n2 != Value.getHigherOrder(n, n2)) {
                            this.swap();
                            int n3 = n;
                            n = n2;
                            n2 = n3;
                        }
                        if (n == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            function.setParameter(1, this.left);
                            function.setParameter(2, this.right);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 6 || n == 8 || n == 7) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.left = new Operation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.left);
                            function.setParameter(1, this.left);
                            function.setParameter(2, this.right);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 9 && n2 == 9) {
                            this.dataType = 9;
                            return this;
                        }
                        if (n == 9) {
                            this.dataType = 11;
                            return this;
                        }
                    } else if (this.opType == OpType.MINUS) {
                        if ((n == 10 || n == 11) && n2 == 4) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                            this.right = new Operation(OpType.NEGATE, this.right, null);
                            this.right = this.right.optimize(session);
                            function.setParameter(1, this.right);
                            function.setParameter(2, this.left);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (!(n != 10 && n != 11 || n2 != 6 && n2 != 8 && n2 != 7)) {
                            Function function = Function.getFunction(session.getDatabase(), "DATEADD");
                            function.setParameter(0, ValueExpression.get(ValueString.get("SECOND")));
                            this.right = new Operation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.right);
                            this.right = new Operation(OpType.NEGATE, this.right, null);
                            this.right = this.right.optimize(session);
                            function.setParameter(1, this.right);
                            function.setParameter(2, this.left);
                            function.doneWithParameters();
                            return function.optimize(session);
                        }
                        if (n == 10 || n == 11) {
                            if (n2 == 9) {
                                this.dataType = 11;
                                return this;
                            }
                            if (n2 == 10 || n2 == 11) {
                                Function function = Function.getFunction(session.getDatabase(), "DATEDIFF");
                                function.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                                function.setParameter(1, this.right);
                                function.setParameter(2, this.left);
                                function.doneWithParameters();
                                return function.optimize(session);
                            }
                        } else if (n == 9 && n2 == 9) {
                            this.dataType = 9;
                            return this;
                        }
                    } else if (this.opType == OpType.MULTIPLY) {
                        if (n == 9) {
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                        if (n2 == 9) {
                            this.swap();
                            this.dataType = 9;
                            this.convertRight = false;
                            return this;
                        }
                    } else if (this.opType == OpType.DIVIDE && n == 9) {
                        this.dataType = 9;
                        this.convertRight = false;
                        return this;
                    }
                    throw DbException.getUnsupportedException(DataType.getDataType((int)n).name + " " + this.getOperationToken() + " " + DataType.getDataType((int)n2).name);
                }
                this.dataType = Value.getHigherOrder(n, n2);
                if (!DataType.isStringType(this.dataType) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                this.opType = OpType.CONCAT;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private void swap() {
        Expression expression = this.left;
        this.left = this.right;
        this.right = expression;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public long getPrecision() {
        if (this.right != null) {
            switch (this.opType) {
                case CONCAT: {
                    return this.left.getPrecision() + this.right.getPrecision();
                }
            }
            return Math.max(this.left.getPrecision(), this.right.getPrecision());
        }
        return this.left.getPrecision();
    }

    @Override
    public int getDisplaySize() {
        if (this.right != null) {
            switch (this.opType) {
                case CONCAT: {
                    return MathUtils.convertLongToInt((long)this.left.getDisplaySize() + (long)this.right.getDisplaySize());
                }
            }
            return Math.max(this.left.getDisplaySize(), this.right.getDisplaySize());
        }
        return this.left.getDisplaySize();
    }

    @Override
    public int getScale() {
        if (this.right != null) {
            return Math.max(this.left.getScale(), this.right.getScale());
        }
        return this.left.getScale();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && (this.right == null || this.right.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + (this.right == null ? 0 : this.right.getCost());
    }

    public static enum OpType {
        CONCAT,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        NEGATE,
        MODULUS;

    }
}

