/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import com.alibaba.schedulerx.shade.org.h2.expression.ParameterInterface;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcCallableStatementBackwardsCompat;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcPreparedStatement;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcResultSet;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.BitField;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class JdbcCallableStatement
extends JdbcPreparedStatement
implements CallableStatement,
JdbcCallableStatementBackwardsCompat {
    private BitField outParameters;
    private int maxOutParameters;
    private HashMap<String, Integer> namedParameters;

    JdbcCallableStatement(JdbcConnection jdbcConnection, String string2, int n, int n2, int n3) {
        super(jdbcConnection, string2, n, n2, n3, false, false);
        this.setTrace(this.session.getTrace(), 0, n);
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0;
            }
            return super.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0L;
            }
            return super.executeLargeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string2) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(String string2, int n, String string3) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string2), n, string3);
    }

    @Override
    public void registerOutParameter(String string2, int n, int n2) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string2), n, n2);
    }

    @Override
    public void registerOutParameter(String string2, int n) throws SQLException {
        this.registerOutParameter(this.getIndexForName(string2), n);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOpenResultSet().wasNull();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getString(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBoolean(n);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getByte(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getShort(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getInt(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getLong(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getFloat(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDouble(n);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBigDecimal(n, n2);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBytes(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDate(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTimestamp(n);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getObject(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBigDecimal(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map2) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBlob(n);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getClob(n);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getArray(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDate(n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTimestamp(n, calendar);
    }

    @Override
    public URL getURL(String string2) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public Timestamp getTimestamp(String string2, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getIndexForName(string2), calendar);
    }

    @Override
    public Time getTime(String string2, Calendar calendar) throws SQLException {
        return this.getTime(this.getIndexForName(string2), calendar);
    }

    @Override
    public Date getDate(String string2, Calendar calendar) throws SQLException {
        return this.getDate(this.getIndexForName(string2), calendar);
    }

    @Override
    public Array getArray(String string2) throws SQLException {
        return this.getArray(this.getIndexForName(string2));
    }

    @Override
    public Clob getClob(String string2) throws SQLException {
        return this.getClob(this.getIndexForName(string2));
    }

    @Override
    public Blob getBlob(String string2) throws SQLException {
        return this.getBlob(this.getIndexForName(string2));
    }

    @Override
    public Ref getRef(String string2) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Object getObject(String string2, Map<String, Class<?>> map2) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public BigDecimal getBigDecimal(String string2) throws SQLException {
        return this.getBigDecimal(this.getIndexForName(string2));
    }

    @Override
    public Object getObject(String string2) throws SQLException {
        return this.getObject(this.getIndexForName(string2));
    }

    @Override
    public Timestamp getTimestamp(String string2) throws SQLException {
        return this.getTimestamp(this.getIndexForName(string2));
    }

    @Override
    public Time getTime(String string2) throws SQLException {
        return this.getTime(this.getIndexForName(string2));
    }

    @Override
    public Date getDate(String string2) throws SQLException {
        return this.getDate(this.getIndexForName(string2));
    }

    @Override
    public byte[] getBytes(String string2) throws SQLException {
        return this.getBytes(this.getIndexForName(string2));
    }

    @Override
    public double getDouble(String string2) throws SQLException {
        return this.getDouble(this.getIndexForName(string2));
    }

    @Override
    public float getFloat(String string2) throws SQLException {
        return this.getFloat(this.getIndexForName(string2));
    }

    @Override
    public long getLong(String string2) throws SQLException {
        return this.getLong(this.getIndexForName(string2));
    }

    @Override
    public int getInt(String string2) throws SQLException {
        return this.getInt(this.getIndexForName(string2));
    }

    @Override
    public short getShort(String string2) throws SQLException {
        return this.getShort(this.getIndexForName(string2));
    }

    @Override
    public byte getByte(String string2) throws SQLException {
        return this.getByte(this.getIndexForName(string2));
    }

    @Override
    public boolean getBoolean(String string2) throws SQLException {
        return this.getBoolean(this.getIndexForName(string2));
    }

    @Override
    public String getString(String string2) throws SQLException {
        return this.getString(this.getIndexForName(string2));
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String string2) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNClob(n);
    }

    @Override
    public NClob getNClob(String string2) throws SQLException {
        return this.getNClob(this.getIndexForName(string2));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string2) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNString(n);
    }

    @Override
    public String getNString(String string2) throws SQLException {
        return this.getNString(this.getIndexForName(string2));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string2) throws SQLException {
        return this.getNCharacterStream(this.getIndexForName(string2));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkRegistered(n);
        return this.getOpenResultSet().getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string2) throws SQLException {
        return this.getCharacterStream(this.getIndexForName(string2));
    }

    @Override
    public void setNull(String string2, int n, String string3) throws SQLException {
        this.setNull(this.getIndexForName(string2), n, string3);
    }

    @Override
    public void setNull(String string2, int n) throws SQLException {
        this.setNull(this.getIndexForName(string2), n);
    }

    @Override
    public void setTimestamp(String string2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.getIndexForName(string2), timestamp, calendar);
    }

    @Override
    public void setTime(String string2, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.getIndexForName(string2), time, calendar);
    }

    @Override
    public void setDate(String string2, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.getIndexForName(string2), date, calendar);
    }

    @Override
    public void setCharacterStream(String string2, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string2), reader, n);
    }

    @Override
    public void setObject(String string2, Object object) throws SQLException {
        this.setObject(this.getIndexForName(string2), object);
    }

    @Override
    public void setObject(String string2, Object object, int n) throws SQLException {
        this.setObject(this.getIndexForName(string2), object, n);
    }

    @Override
    public void setObject(String string2, Object object, int n, int n2) throws SQLException {
        this.setObject(this.getIndexForName(string2), object, n, n2);
    }

    @Override
    public void setBinaryStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string2), inputStream, n);
    }

    @Override
    public void setAsciiStream(String string2, InputStream inputStream, long l) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string2), inputStream, l);
    }

    @Override
    public void setTimestamp(String string2, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.getIndexForName(string2), timestamp);
    }

    @Override
    public void setTime(String string2, Time time) throws SQLException {
        this.setTime(this.getIndexForName(string2), time);
    }

    @Override
    public void setDate(String string2, Date date) throws SQLException {
        this.setDate(this.getIndexForName(string2), date);
    }

    @Override
    public void setBytes(String string2, byte[] byArray) throws SQLException {
        this.setBytes(this.getIndexForName(string2), byArray);
    }

    @Override
    public void setString(String string2, String string3) throws SQLException {
        this.setString(this.getIndexForName(string2), string3);
    }

    @Override
    public void setBigDecimal(String string2, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.getIndexForName(string2), bigDecimal);
    }

    @Override
    public void setDouble(String string2, double d) throws SQLException {
        this.setDouble(this.getIndexForName(string2), d);
    }

    @Override
    public void setFloat(String string2, float f) throws SQLException {
        this.setFloat(this.getIndexForName(string2), f);
    }

    @Override
    public void setLong(String string2, long l) throws SQLException {
        this.setLong(this.getIndexForName(string2), l);
    }

    @Override
    public void setInt(String string2, int n) throws SQLException {
        this.setInt(this.getIndexForName(string2), n);
    }

    @Override
    public void setShort(String string2, short s2) throws SQLException {
        this.setShort(this.getIndexForName(string2), s2);
    }

    @Override
    public void setByte(String string2, byte by2) throws SQLException {
        this.setByte(this.getIndexForName(string2), by2);
    }

    @Override
    public void setBoolean(String string2, boolean bl) throws SQLException {
        this.setBoolean(this.getIndexForName(string2), bl);
    }

    @Override
    public void setURL(String string2, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void setRowId(String string2, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(String string2, String string3) throws SQLException {
        this.setNString(this.getIndexForName(string2), string3);
    }

    @Override
    public void setNCharacterStream(String string2, Reader reader, long l) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(string2), reader, l);
    }

    @Override
    public void setNClob(String string2, NClob nClob) throws SQLException {
        this.setNClob(this.getIndexForName(string2), nClob);
    }

    @Override
    public void setClob(String string2, Reader reader, long l) throws SQLException {
        this.setClob(this.getIndexForName(string2), reader, l);
    }

    @Override
    public void setBlob(String string2, InputStream inputStream, long l) throws SQLException {
        this.setBlob(this.getIndexForName(string2), inputStream, l);
    }

    @Override
    public void setNClob(String string2, Reader reader, long l) throws SQLException {
        this.setNClob(this.getIndexForName(string2), reader, l);
    }

    @Override
    public void setBlob(String string2, Blob blob) throws SQLException {
        this.setBlob(this.getIndexForName(string2), blob);
    }

    @Override
    public void setClob(String string2, Clob clob) throws SQLException {
        this.setClob(this.getIndexForName(string2), clob);
    }

    @Override
    public void setAsciiStream(String string2, InputStream inputStream) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string2), inputStream);
    }

    @Override
    public void setAsciiStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.getIndexForName(string2), inputStream, n);
    }

    @Override
    public void setBinaryStream(String string2, InputStream inputStream) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string2), inputStream);
    }

    @Override
    public void setBinaryStream(String string2, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(this.getIndexForName(string2), inputStream, l);
    }

    @Override
    public void setBlob(String string2, InputStream inputStream) throws SQLException {
        this.setBlob(this.getIndexForName(string2), inputStream);
    }

    @Override
    public void setCharacterStream(String string2, Reader reader) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string2), reader);
    }

    @Override
    public void setCharacterStream(String string2, Reader reader, long l) throws SQLException {
        this.setCharacterStream(this.getIndexForName(string2), reader, l);
    }

    @Override
    public void setClob(String string2, Reader reader) throws SQLException {
        this.setClob(this.getIndexForName(string2), reader);
    }

    @Override
    public void setNCharacterStream(String string2, Reader reader) throws SQLException {
        this.setNCharacterStream(this.getIndexForName(string2), reader);
    }

    @Override
    public void setNClob(String string2, Reader reader) throws SQLException {
        this.setNClob(this.getIndexForName(string2), reader);
    }

    @Override
    public void setSQLXML(String string2, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return this.getOpenResultSet().getObject(n, clazz);
    }

    @Override
    public <T> T getObject(String string2, Class<T> clazz) throws SQLException {
        return this.getObject(this.getIndexForName(string2), clazz);
    }

    private ResultSetMetaData getCheckedMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        if (resultSetMetaData == null) {
            throw DbException.getUnsupportedException("Supported only for calling stored procedures");
        }
        return resultSetMetaData;
    }

    private void checkIndexBounds(int n) {
        this.checkClosed();
        if (n < 1 || n > this.maxOutParameters) {
            throw DbException.getInvalidValueException("parameterIndex", n);
        }
    }

    private void registerOutParameter(int n) throws SQLException {
        try {
            this.checkClosed();
            if (this.outParameters == null) {
                this.maxOutParameters = Math.min(this.getParameterMetaData().getParameterCount(), this.getCheckedMetaData().getColumnCount());
                this.outParameters = new BitField();
            }
            this.checkIndexBounds(n);
            ParameterInterface parameterInterface = this.command.getParameters().get(--n);
            if (!parameterInterface.isValueSet()) {
                parameterInterface.setValue(ValueNull.INSTANCE, false);
            }
            this.outParameters.set(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkRegistered(int n) throws SQLException {
        try {
            this.checkIndexBounds(n);
            if (!this.outParameters.get(n - 1)) {
                throw DbException.getInvalidValueException("parameterIndex", n);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private int getIndexForName(String string2) throws SQLException {
        try {
            Object object;
            this.checkClosed();
            if (this.namedParameters == null) {
                object = this.getCheckedMetaData();
                int n = object.getColumnCount();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n);
                for (int i = 1; i <= n; ++i) {
                    hashMap.put(object.getColumnLabel(i), i);
                }
                this.namedParameters = hashMap;
            }
            if ((object = this.namedParameters.get(string2)) == null) {
                throw DbException.getInvalidValueException("parameterName", string2);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcResultSet getOpenResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet == null) {
                throw DbException.get(2000);
            }
            if (this.resultSet.isBeforeFirst()) {
                this.resultSet.next();
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }
}

