/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.message.TraceObject;
import com.alibaba.schedulerx.shade.org.h2.store.RangeReader;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Task;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

public class JdbcClob
extends TraceObject
implements NClob {
    Value value;
    private final JdbcConnection conn;

    public JdbcClob(JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 10, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    @Override
    public long length() throws SQLException {
        try {
            long l;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 16 && (l = this.value.getPrecision()) > 0L) {
                return l;
            }
            return IOUtils.copyAndCloseInput(this.value.getReader(), null, Long.MAX_VALUE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String string2 = this.value.getString();
            return IOUtils.getInputStreamFromString(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setCharacterStream(" + l + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection = this.conn;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                @Override
                public void call() {
                    JdbcClob.this.value = jdbcConnection.createClob(IOUtils.getReader(pipedInputStream), -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return IOUtils.getBufferedWriter(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSubString(" + l + ", " + n + ");");
            }
            this.checkClosed();
            if (l < 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (n < 0) {
                throw DbException.getInvalidValueException("length", n);
            }
            StringWriter stringWriter = new StringWriter(Math.min(4096, n));
            try (Reader reader = this.value.getReader();){
                IOUtils.skipFully(reader, l - 1L);
                IOUtils.copyAndCloseInput(reader, stringWriter, n);
            }
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setString(long l, String string2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + l + ", " + JdbcClob.quote(string2) + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (string2 == null) {
                throw DbException.getInvalidValueException("str", string2);
            }
            this.value = this.conn.createClob(new StringReader(string2), -1L);
            return string2.length();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setString(long l, String string2, int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + l + ", " + JdbcClob.quote(string2) + ", " + n + ", " + n2 + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (string2 == null) {
                throw DbException.getInvalidValueException("str", string2);
            }
            this.value = this.conn.createClob(new RangeReader(new StringReader(string2), n, n2), -1L);
            return (int)this.value.getPrecision();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long position(String string2, long l) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream(pos, length)");
            this.checkClosed();
            return this.value.getReader(l, l2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

