/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.tools;

import com.alibaba.schedulerx.shade.org.h2.Driver;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.JdbcUtils;
import com.alibaba.schedulerx.shade.org.h2.util.ScriptReader;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Tool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;

public class RunScript
extends Tool {
    private boolean showResults;
    private boolean checkResults;

    public static void main(String ... stringArray) throws SQLException {
        new RunScript().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string2 = null;
        String string3 = "";
        String string4 = "";
        String string5 = "backup.sql";
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            CharSequence charSequence;
            String string7 = stringArray[i];
            if (string7.equals("-url")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string7.equals("-user")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string7.equals("-password")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string7.equals("-continueOnError")) {
                bl = true;
                continue;
            }
            if (string7.equals("-checkResults")) {
                this.checkResults = true;
                continue;
            }
            if (string7.equals("-showResults")) {
                this.showResults = true;
                continue;
            }
            if (string7.equals("-script")) {
                string5 = stringArray[++i];
                continue;
            }
            if (string7.equals("-time")) {
                bl2 = true;
                continue;
            }
            if (string7.equals("-driver")) {
                charSequence = stringArray[++i];
                JdbcUtils.loadUserClass((String)charSequence);
                continue;
            }
            if (string7.equals("-options")) {
                charSequence = new StringBuilder();
                ++i;
                while (i < stringArray.length) {
                    ((StringBuilder)charSequence).append(' ').append(stringArray[i]);
                    ++i;
                }
                string6 = ((StringBuilder)charSequence).toString();
                continue;
            }
            if (string7.equals("-help") || string7.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string7);
        }
        if (string2 == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        long l = System.nanoTime();
        if (string6 != null) {
            RunScript.processRunscript(string2, string3, string4, string5, string6);
        } else {
            this.process(string2, string3, string4, string5, null, bl);
        }
        if (bl2) {
            l = System.nanoTime() - l;
            this.out.println("Done in " + TimeUnit.NANOSECONDS.toMillis(l) + " ms");
        }
    }

    public static ResultSet execute(Connection connection, Reader reader) throws SQLException {
        String string2;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        ScriptReader scriptReader = new ScriptReader(reader);
        while ((string2 = scriptReader.readStatement()) != null) {
            boolean bl;
            if (string2.trim().length() == 0 || !(bl = statement.execute(string2))) continue;
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            resultSet = statement.getResultSet();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Connection connection, String string2, boolean bl, Charset charset) throws SQLException, IOException {
        InputStream inputStream = FileUtils.newInputStream(string2);
        String string3 = FileUtils.getParent(string2);
        try {
            inputStream = new BufferedInputStream(inputStream, 4096);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            this.process(connection, bl, string3, inputStreamReader, charset);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    private void process(Connection connection, boolean bl, String string2, Reader reader, Charset charset) throws SQLException, IOException {
        String string3;
        Statement statement = connection.createStatement();
        ScriptReader scriptReader = new ScriptReader(reader);
        while ((string3 = scriptReader.readStatement()) != null) {
            String string4 = string3.trim();
            if (string4.length() == 0) continue;
            if (string4.startsWith("@") && StringUtils.toUpperEnglish(string4).startsWith("@INCLUDE")) {
                string3 = string4;
                if (!FileUtils.isAbsolute(string3 = string3.substring("@INCLUDE".length()).trim())) {
                    string3 = string2 + SysProperties.FILE_SEPARATOR + string3;
                }
                this.process(connection, string3, bl, charset);
                continue;
            }
            try {
                if (this.showResults && !string4.startsWith("-->")) {
                    this.out.print(string3 + ";");
                }
                if (this.showResults || this.checkResults) {
                    String string5;
                    boolean bl2 = statement.execute(string3);
                    if (!bl2) continue;
                    ResultSet resultSet = statement.getResultSet();
                    int n = resultSet.getMetaData().getColumnCount();
                    StringBuilder stringBuilder = new StringBuilder();
                    while (resultSet.next()) {
                        stringBuilder.append("\n-->");
                        for (int i = 0; i < n; ++i) {
                            string5 = resultSet.getString(i + 1);
                            if (string5 != null) {
                                string5 = StringUtils.replaceAll(string5, "\r\n", "\n");
                                string5 = StringUtils.replaceAll(string5, "\n", "\n-->    ");
                                string5 = StringUtils.replaceAll(string5, "\r", "\r-->    ");
                            }
                            stringBuilder.append(' ').append(string5);
                        }
                    }
                    stringBuilder.append("\n;");
                    String string6 = stringBuilder.toString();
                    if (this.showResults) {
                        this.out.print(string6);
                    }
                    if (!this.checkResults) continue;
                    string5 = scriptReader.readStatement() + ";";
                    string5 = StringUtils.replaceAll(string5, "\r\n", "\n");
                    if ((string5 = StringUtils.replaceAll(string5, "\r", "\n")).equals(string6)) continue;
                    string5 = StringUtils.replaceAll(string5, " ", "+");
                    string6 = StringUtils.replaceAll(string6, " ", "+");
                    throw new SQLException("Unexpected output for:\n" + string3.trim() + "\nGot:\n" + string6 + "\nExpected:\n" + string5);
                }
                statement.execute(string3);
            }
            catch (Exception exception) {
                if (bl) {
                    exception.printStackTrace(this.out);
                    continue;
                }
                throw DbException.toSQLException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRunscript(String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string2, string3, string4);
            statement = connection.createStatement();
            String string7 = "RUNSCRIPT FROM '" + string5 + "' " + string6;
            statement.execute(string7);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
    }

    public static void execute(String string2, String string3, String string4, String string5, Charset charset, boolean bl) throws SQLException {
        new RunScript().process(string2, string3, string4, string5, charset, bl);
    }

    void process(String string2, String string3, String string4, String string5, Charset charset, boolean bl) throws SQLException {
        try {
            Driver.load();
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            try (Connection connection = DriverManager.getConnection(string2, string3, string4);){
                this.process(connection, string5, bl, charset);
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string5);
        }
    }
}

