/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.upgrade;

import com.alibaba.schedulerx.shade.org.h2.engine.ConnectionInfo;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class DbUpgrade {
    private static final boolean UPGRADE_CLASSES_PRESENT = Utils.isClassPresent("com.alibaba.schedulerx.shade.org.h2.upgrade.v1_1.Driver");
    private static boolean scriptInTempDir;
    private static boolean deleteOldDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connectOrUpgrade(String string2, Properties properties) throws SQLException {
        ConnectionInfo connectionInfo;
        if (!UPGRADE_CLASSES_PRESENT) {
            return null;
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Object object = properties.get("password");
        if (object instanceof char[]) {
            properties2.put("password", StringUtils.cloneCharArray((char[])object));
        }
        if ((connectionInfo = new ConnectionInfo(string2, properties = properties2)).isRemote() || !connectionInfo.isPersistent()) {
            return null;
        }
        String string3 = connectionInfo.getName();
        if (FileUtils.exists(string3 + ".h2.db")) {
            return null;
        }
        if (!FileUtils.exists(string3 + ".data.db")) {
            return null;
        }
        if (connectionInfo.removeProperty("NO_UPGRADE", false)) {
            return DbUpgrade.connectWithOldVersion(string2, properties);
        }
        Class<DbUpgrade> clazz = DbUpgrade.class;
        synchronized (DbUpgrade.class) {
            DbUpgrade.upgrade(connectionInfo, properties);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return null;
        }
    }

    public static void setScriptInTempDir(boolean bl) {
        scriptInTempDir = bl;
    }

    public static void setDeleteOldDb(boolean bl) {
        deleteOldDb = bl;
    }

    private static Connection connectWithOldVersion(String string2, Properties properties) throws SQLException {
        string2 = "jdbc:h2v1_1:" + string2.substring("jdbc:h2:".length()) + ";IGNORE_UNKNOWN_SETTINGS=TRUE";
        return DriverManager.getConnection(string2, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void upgrade(ConnectionInfo connectionInfo, Properties properties) throws SQLException {
        String string2 = connectionInfo.getName();
        String string3 = string2 + ".data.db";
        String string4 = string2 + ".index.db";
        String string5 = string2 + ".lobs.db";
        String string6 = string3 + ".backup";
        String string7 = string4 + ".backup";
        String string8 = string5 + ".backup";
        String string9 = null;
        try {
            if (scriptInTempDir) {
                new File(Utils.getProperty("java.io.tmpdir", ".")).mkdirs();
                string9 = File.createTempFile("h2dbmigration", "backup.sql").getAbsolutePath();
            } else {
                string9 = string2 + ".script.sql";
            }
            String string10 = "jdbc:h2v1_1:" + string2 + ";UNDO_LOG=0;LOG=0;LOCK_MODE=0";
            String string11 = connectionInfo.getProperty("CIPHER", null);
            if (string11 != null) {
                string10 = string10 + ";CIPHER=" + string11;
            }
            Connection connection = DriverManager.getConnection(string10, properties);
            Statement statement = connection.createStatement();
            String string12 = UUID.randomUUID().toString();
            if (string11 != null) {
                statement.execute("script to '" + string9 + "' cipher aes password '" + string12 + "' --hide--");
            } else {
                statement.execute("script to '" + string9 + "'");
            }
            connection.close();
            FileUtils.move(string3, string6);
            FileUtils.move(string4, string7);
            if (FileUtils.exists(string5)) {
                FileUtils.move(string5, string8);
            }
            connectionInfo.removeProperty("IFEXISTS", false);
            connection = new JdbcConnection(connectionInfo, true);
            statement = connection.createStatement();
            if (string11 != null) {
                statement.execute("runscript from '" + string9 + "' cipher aes password '" + string12 + "' --hide--");
            } else {
                statement.execute("runscript from '" + string9 + "'");
            }
            statement.execute("analyze");
            statement.execute("shutdown compact");
            statement.close();
            connection.close();
            if (deleteOldDb) {
                FileUtils.delete(string6);
                FileUtils.delete(string7);
                FileUtils.deleteRecursive(string8, false);
            }
            if (string9 == null) return;
        }
        catch (Exception exception) {
            try {
                if (FileUtils.exists(string6)) {
                    FileUtils.move(string6, string3);
                }
                if (FileUtils.exists(string7)) {
                    FileUtils.move(string7, string4);
                }
                if (FileUtils.exists(string8)) {
                    FileUtils.move(string8, string5);
                }
                FileUtils.delete(string2 + ".h2.db");
                throw DbException.toSQLException(exception);
            }
            catch (Throwable throwable) {
                if (string9 == null) throw throwable;
                FileUtils.delete(string9);
                throw throwable;
            }
        }
        FileUtils.delete(string9);
        return;
    }
}

