/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int NULL = 3;
    public static final int TRUE = 4;
    public static final int FALSE = 5;
    public static final int ROWNUM = 6;

    private ParserUtil() {
    }

    public static boolean isKeyword(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(string2, false) != 2;
    }

    public static boolean isSimpleIdentifier(String string2, boolean bl) {
        if (string2.length() == 0) {
            return false;
        }
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return false;
        }
        int n = string2.length();
        for (int i = 1; i < n; ++i) {
            c = string2.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(string2, bl) == 2;
    }

    public static int getSaveTokenType(String string2, boolean bl) {
        switch (string2.charAt(0)) {
            case 'A': {
                return ParserUtil.getKeywordOrIdentifier(string2, "ALL", 1);
            }
            case 'C': {
                if ("CHECK".equals(string2)) {
                    return 1;
                }
                if ("CONSTRAINT".equals(string2)) {
                    return 1;
                }
                if ("CROSS".equals(string2)) {
                    return 1;
                }
                if (bl && ("CURRENT_DATE".equals(string2) || "CURRENT_TIME".equals(string2) || "CURRENT_TIMESTAMP".equals(string2))) {
                    return 1;
                }
                return 2;
            }
            case 'D': {
                return ParserUtil.getKeywordOrIdentifier(string2, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "EXISTS", 1);
            }
            case 'F': {
                if ("FETCH".equals(string2)) {
                    return 1;
                }
                if ("FROM".equals(string2)) {
                    return 1;
                }
                if ("FOR".equals(string2)) {
                    return 1;
                }
                if ("FOREIGN".equals(string2)) {
                    return 1;
                }
                if ("FULL".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "FALSE", 5);
            }
            case 'G': {
                return ParserUtil.getKeywordOrIdentifier(string2, "GROUP", 1);
            }
            case 'H': {
                return ParserUtil.getKeywordOrIdentifier(string2, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(string2)) {
                    return 1;
                }
                if ("INTERSECT".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "IS", 1);
            }
            case 'J': {
                return ParserUtil.getKeywordOrIdentifier(string2, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "LIKE", 1);
            }
            case 'M': {
                return ParserUtil.getKeywordOrIdentifier(string2, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(string2)) {
                    return 1;
                }
                if ("NATURAL".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "NULL", 3);
            }
            case 'O': {
                if ("OFFSET".equals(string2)) {
                    return 1;
                }
                if ("ON".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "ORDER", 1);
            }
            case 'P': {
                return ParserUtil.getKeywordOrIdentifier(string2, "PRIMARY", 1);
            }
            case 'R': {
                return ParserUtil.getKeywordOrIdentifier(string2, "ROWNUM", 6);
            }
            case 'S': {
                if ("SELECT".equals(string2)) {
                    return 1;
                }
                if (bl && ("SYSDATE".equals(string2) || "SYSTIME".equals(string2) || "SYSTIMESTAMP".equals(string2))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if ("TRUE".equals(string2)) {
                    return 4;
                }
                if (bl && "TODAY".equals(string2)) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if ("UNIQUE".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "UNION", 1);
            }
            case 'W': {
                if ("WITH".equals(string2)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string2, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String string2, String string3, int n) {
        if (string2.equals(string3)) {
            return n;
        }
        return 2;
    }
}

