/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.FileLister;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Properties;

public abstract class Tool {
    protected PrintStream out = System.out;
    private Properties resources;

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public abstract void runTool(String ... var1) throws SQLException;

    protected SQLException showUsageAndThrowUnsupportedOption(String string2) throws SQLException {
        this.showUsage();
        throw this.throwUnsupportedOption(string2);
    }

    protected SQLException throwUnsupportedOption(String string2) throws SQLException {
        throw DbException.get(50100, string2).getSQLException();
    }

    protected void printNoDatabaseFilesFound(String string2, String string3) {
        StringBuilder stringBuilder;
        if (!FileUtils.isDirectory(string2 = FileLister.getDir(string2))) {
            stringBuilder = new StringBuilder("Directory not found: ");
            stringBuilder.append(string2);
        } else {
            stringBuilder = new StringBuilder("No database files have been found");
            stringBuilder.append(" in directory ").append(string2);
            if (string3 != null) {
                stringBuilder.append(" for the database ").append(string3);
            }
        }
        this.out.println(stringBuilder.toString());
    }

    protected void showUsage() {
        String string2;
        if (this.resources == null) {
            this.resources = new Properties();
            string2 = "/com/alibaba/schedulerx/shade/org/h2/res/javadoc.properties";
            try {
                byte[] byArray = Utils.getResource(string2);
                if (byArray != null) {
                    this.resources.load(new ByteArrayInputStream(byArray));
                }
            }
            catch (IOException iOException) {
                this.out.println("Cannot load " + string2);
            }
        }
        string2 = this.getClass().getName();
        this.out.println(this.resources.get(string2));
        this.out.println("Usage: java " + this.getClass().getName() + " <options>");
        this.out.println(this.resources.get(string2 + ".main"));
        this.out.println("See also http://h2database.com/javadoc/" + string2.replace('.', '/') + ".html");
    }

    public static boolean isOption(String string2, String string3) {
        if (string2.equals(string3)) {
            return true;
        }
        if (string2.startsWith(string3)) {
            throw DbException.getUnsupportedException("expected: " + string3 + " got: " + string2);
        }
        return false;
    }
}

