/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.buffer;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.AbstractChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBufferFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.DirectChannelBufferFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.HeapChannelBufferFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class ByteBufferBackedChannelBuffer
extends AbstractChannelBuffer {
    private final ByteBuffer buffer;
    private final ByteOrder order;
    private final int capacity;

    public ByteBufferBackedChannelBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.order = buffer.order();
        this.buffer = buffer.slice().order(this.order);
        this.capacity = buffer.remaining();
        this.writerIndex(this.capacity);
    }

    private ByteBufferBackedChannelBuffer(ByteBufferBackedChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.order = buffer.order;
        this.capacity = buffer.capacity;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    public ChannelBufferFactory factory() {
        if (this.buffer.isDirect()) {
            return DirectChannelBufferFactory.getInstance(this.order());
        }
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public ByteOrder order() {
        return this.order;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public int getUnsignedMedium(int index) {
        return (this.getByte(index) & 0xFF) << 16 | (this.getByte(index + 1) & 0xFF) << 8 | this.getByte(index + 2) & 0xFF;
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        if (dst instanceof ByteBufferBackedChannelBuffer) {
            ByteBufferBackedChannelBuffer bbdst = (ByteBufferBackedChannelBuffer)dst;
            ByteBuffer data = bbdst.buffer.duplicate();
            data.limit(dstIndex + length).position(dstIndex);
            this.getBytes(index, data);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        ByteBuffer data = this.buffer.duplicate();
        try {
            data.limit(index + length).position(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length) + ", maximum is " + data.limit());
        }
        data.get(dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        ByteBuffer data = this.buffer.duplicate();
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        try {
            data.limit(index + bytesToCopy).position(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + bytesToCopy) + ", maximum is " + data.limit());
        }
        dst.put(data);
    }

    public void setByte(int index, int value) {
        this.buffer.put(index, (byte)value);
    }

    public void setShort(int index, int value) {
        this.buffer.putShort(index, (short)value);
    }

    public void setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)value);
    }

    public void setInt(int index, int value) {
        this.buffer.putInt(index, value);
    }

    public void setLong(int index, long value) {
        this.buffer.putLong(index, value);
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        if (src instanceof ByteBufferBackedChannelBuffer) {
            ByteBufferBackedChannelBuffer bbsrc = (ByteBufferBackedChannelBuffer)src;
            ByteBuffer data = bbsrc.buffer.duplicate();
            data.limit(srcIndex + length).position(srcIndex);
            this.setBytes(index, data);
        } else if (this.buffer.hasArray()) {
            src.getBytes(srcIndex, this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            src.getBytes(srcIndex, this, index, length);
        }
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        ByteBuffer data = this.buffer.duplicate();
        data.limit(index + length).position(index);
        data.put(src, srcIndex, length);
    }

    public void setBytes(int index, ByteBuffer src) {
        ByteBuffer data = this.buffer.duplicate();
        data.limit(index + src.remaining()).position(index);
        data.put(src);
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            ((ByteBuffer)this.buffer.duplicate().position(index)).get(tmp);
            out.write(tmp);
        }
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return out.write((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length));
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        int readBytes = 0;
        if (this.buffer.hasArray()) {
            int localReadBytes;
            index += this.buffer.arrayOffset();
            do {
                if ((localReadBytes = in.read(this.buffer.array(), index, length)) < 0) {
                    if (readBytes == 0) {
                        return -1;
                    }
                    break;
                }
                readBytes += localReadBytes;
                index += localReadBytes;
            } while ((length -= localReadBytes) > 0);
        } else {
            int localReadBytes;
            byte[] tmp = new byte[length];
            int i = 0;
            do {
                if ((localReadBytes = in.read(tmp, i, tmp.length - i)) >= 0) continue;
                if (readBytes != 0) break;
                return -1;
            } while ((i += (readBytes += localReadBytes)) < tmp.length);
            ((ByteBuffer)this.buffer.duplicate().position(index)).put(tmp);
        }
        return readBytes;
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int readBytes;
        int localReadBytes;
        ByteBuffer slice2 = (ByteBuffer)this.buffer.duplicate().limit(index + length).position(index);
        for (readBytes = 0; readBytes < length; readBytes += localReadBytes) {
            try {
                localReadBytes = in.read(slice2);
            }
            catch (ClosedChannelException e) {
                localReadBytes = -1;
            }
            if (localReadBytes < 0) {
                if (readBytes == 0) {
                    return -1;
                }
                return readBytes;
            }
            if (localReadBytes == 0) break;
        }
        return readBytes;
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            return this.buffer.duplicate().order(this.order());
        }
        return ((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length)).slice().order(this.order());
    }

    public ChannelBuffer slice(int index, int length) {
        if (index == 0 && length == this.capacity()) {
            ChannelBuffer slice2 = this.duplicate();
            slice2.setIndex(0, length);
            return slice2;
        }
        if (index >= 0 && length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new ByteBufferBackedChannelBuffer(((ByteBuffer)this.buffer.duplicate().position(index).limit(index + length)).order(this.order()));
    }

    public ChannelBuffer duplicate() {
        return new ByteBufferBackedChannelBuffer(this);
    }

    public ChannelBuffer copy(int index, int length) {
        ByteBuffer src;
        try {
            src = (ByteBuffer)this.buffer.duplicate().position(index).limit(index + length);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index + length));
        }
        ByteBuffer dst = this.buffer.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new ByteBufferBackedChannelBuffer(dst);
    }
}

