/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.Boss;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.BossPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLogger;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLoggerFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ExternalResourceReleasable;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNioBossPool<E extends Boss>
implements BossPool<E>,
ExternalResourceReleasable {
    private static final int INITIALIZATION_TIMEOUT = 10;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioBossPool.class);
    private final Boss[] bosses;
    private final AtomicInteger bossIndex = new AtomicInteger();
    private final Executor bossExecutor;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    AbstractNioBossPool(Executor bossExecutor, int bossCount) {
        this(bossExecutor, bossCount, true);
    }

    AbstractNioBossPool(Executor bossExecutor, int bossCount, boolean autoInit) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (bossCount <= 0) {
            throw new IllegalArgumentException("bossCount (" + bossCount + ") must be a positive integer.");
        }
        this.bosses = new Boss[bossCount];
        this.bossExecutor = bossExecutor;
        if (autoInit) {
            this.init();
        }
    }

    protected void init() {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("initialized already");
        }
        for (int i = 0; i < this.bosses.length; ++i) {
            this.bosses[i] = this.newBoss(this.bossExecutor);
        }
        this.waitForBossThreads();
    }

    private void waitForBossThreads() {
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        boolean warn = false;
        for (Boss boss : this.bosses) {
            if (!(boss instanceof AbstractNioSelector)) continue;
            AbstractNioSelector selector = (AbstractNioSelector)((Object)boss);
            long waitTime = deadline - System.nanoTime();
            try {
                if (waitTime <= 0L) {
                    if (selector.thread != null) continue;
                    warn = true;
                    break;
                }
                if (selector.startupLatch.await(waitTime, TimeUnit.NANOSECONDS)) continue;
                warn = true;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            break;
        }
        if (warn) {
            logger.warn("Failed to get all boss threads ready within 10 second(s). Make sure to specify the executor which has more threads than the requested bossCount. If unsure, use Executors.newCachedThreadPool().");
        }
    }

    protected abstract E newBoss(Executor var1);

    @Override
    public E nextBoss() {
        return (E)this.bosses[Math.abs(this.bossIndex.getAndIncrement() % this.bosses.length)];
    }

    @Override
    public void rebuildSelectors() {
        for (Boss boss : this.bosses) {
            boss.rebuildSelector();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.shutdownNow(this.bossExecutor);
    }

    @Override
    public void shutdown() {
        for (Boss boss : this.bosses) {
            boss.shutdown();
        }
    }
}

