/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.SocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.BossPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioClientBoss;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioClientBossPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioClientSocketPipelineSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioWorkerPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.SelectorUtil;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.WorkerPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ExternalResourceReleasable;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private static final int DEFAULT_BOSS_COUNT = 1;
    private final BossPool<NioClientBoss> bossPool;
    private final WorkerPool<NioWorker> workerPool;
    private final NioClientSocketPipelineSink sink;
    private boolean releasePools;

    public NioClientSocketChannelFactory() {
        this(Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
        this.releasePools = true;
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, 1, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        this(bossExecutor, workerExecutor, 1, workerCount);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int bossCount, int workerCount) {
        this(bossExecutor, bossCount, new NioWorkerPool(workerExecutor, workerCount));
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, int bossCount, WorkerPool<NioWorker> workerPool) {
        this(new NioClientBossPool(bossExecutor, bossCount), workerPool);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, int bossCount, WorkerPool<NioWorker> workerPool, Timer timer) {
        this(new NioClientBossPool(bossExecutor, bossCount, timer, null), workerPool);
    }

    public NioClientSocketChannelFactory(BossPool<NioClientBoss> bossPool, WorkerPool<NioWorker> workerPool) {
        if (bossPool == null) {
            throw new NullPointerException("bossPool");
        }
        if (workerPool == null) {
            throw new NullPointerException("workerPool");
        }
        this.bossPool = bossPool;
        this.workerPool = workerPool;
        this.sink = new NioClientSocketPipelineSink(bossPool);
    }

    @Override
    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new NioClientSocketChannel(this, pipeline, this.sink, this.workerPool.nextWorker());
    }

    @Override
    public void shutdown() {
        this.bossPool.shutdown();
        this.workerPool.shutdown();
        if (this.releasePools) {
            this.releasePools();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.bossPool.shutdown();
        this.workerPool.shutdown();
        this.releasePools();
    }

    private void releasePools() {
        if (this.bossPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.bossPool)).releaseExternalResources();
        }
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
    }
}

